/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.server;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.EngineController;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.MessageUtil;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.server.RexProRequest;
import com.tinkerpop.rexster.protocol.session.RexProSession;
import com.tinkerpop.rexster.protocol.session.RexProSessions;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SessionServer {
    private static final Logger logger = Logger.getLogger(SessionServer.class);
    private final RexsterApplication rexsterApplication;

    public SessionServer(RexsterApplication rexsterApplication) {
        this.rexsterApplication = rexsterApplication;
        String metricName = MetricRegistry.name((String)"rexpro", (String[])new String[]{"sessions"});
        if (!this.rexsterApplication.getMetricRegistry().getGauges().containsKey(metricName)) {
            this.rexsterApplication.getMetricRegistry().register(metricName, (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return RexProSessions.getSessionKeys().size();
                }
            });
        }
    }

    public void handleRequest(SessionRequestMessage message, RexProRequest request) throws IOException {
        try {
            message.validateMetaData();
        }
        catch (Exception e) {
            logger.error((Object)e);
            request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_MESSAGE_ERROR, e.toString()));
        }
        if (message.metaGetKillSession().booleanValue()) {
            RexProSessions.destroySession(message.sessionAsUUID().toString());
            request.writeResponseMessage(MessageUtil.createEmptySession(message.Request));
        } else {
            EngineController engineController = EngineController.getInstance();
            List<String> engineLanguages = engineController.getAvailableEngineLanguages();
            SessionResponseMessage responseMessage = MessageUtil.createNewSession(message.Request, engineLanguages);
            if (!RexProSessions.hasSessionKey(responseMessage.sessionAsUUID().toString())) {
                RexProSession session = RexProSessions.createSession(responseMessage.sessionAsUUID().toString(), this.rexsterApplication);
                request.setSession(session);
                if (message.metaGetGraphName() != null) {
                    try {
                        session.setGraphObj(message.metaGetGraphName(), message.metaGetGraphObjName());
                    }
                    catch (RexProException ex) {
                        request.writeResponseMessage(MessageUtil.createErrorResponse(message.Request, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.GRAPH_CONFIG_ERROR, ex.toString()));
                        return;
                    }
                }
            }
            request.writeResponseMessage(responseMessage);
        }
    }
}

