/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.session;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.rexster.protocol.session.AbstractRexProSession;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.script.ScriptException;

public class RexProSession
extends AbstractRexProSession {
    private final String sessionKey;
    private Date lastTimeUsed = new Date();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public RexProSession(String sessionKey, RexsterApplication rexsterApplication) {
        super(rexsterApplication);
        this.sessionKey = sessionKey;
    }

    public void kill() {
        this.executor.shutdown();
    }

    public long getIdleTime() {
        return new Date().getTime() - this.lastTimeUsed.getTime();
    }

    @Override
    protected void execute(AbstractRexProSession.Evaluator evaluator) throws ScriptException {
        try {
            this.executor.submit(evaluator).get();
        }
        catch (Exception e) {
            for (String graphName : this.rexsterApplication.getGraphNames()) {
                try {
                    Graph g = this.rexsterApplication.getGraph(graphName);
                    if (!(g instanceof TransactionalGraph)) continue;
                    ((TransactionalGraph)g).stopTransaction(TransactionalGraph.Conclusion.FAILURE);
                }
                catch (Throwable t) {}
            }
            throw new ScriptException(e);
        }
        finally {
            this.lastTimeUsed = new Date();
        }
    }
}

