/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import org.jboss.forge.roaster.model.util.Types;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;
import org.jboss.windup.rules.apps.java.model.AmbiguousJavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaParameterModel;
import org.jboss.windup.util.ExecutionStatistics;

public class JavaClassService
extends GraphService<JavaClassModel> {
    public JavaClassService(GraphContext context) {
        super(context, JavaClassModel.class);
    }

    public JavaClassModel getUniqueByName(String qualifiedName) throws NonUniqueResultException {
        ExecutionStatistics.get().begin("getUniqueByName(qualifiedName)");
        JavaClassModel result = (JavaClassModel)this.getUniqueByProperty("qualifiedName", qualifiedName);
        ExecutionStatistics.get().end("getUniqueByName(qualifiedName)");
        return result;
    }

    public synchronized JavaClassModel getOrCreate(String qualifiedName) throws NonUniqueResultException {
        ExecutionStatistics.get().begin("JavaClassService.getOrCreate(qualifiedName)");
        JavaClassModel clz = this.resolveByQualifiedName(qualifiedName);
        if (clz == null) {
            clz = (JavaClassModel)this.create();
            clz.setQualifiedName(qualifiedName);
            clz.setSimpleName(Types.toSimpleName((String)qualifiedName));
            clz.setPackageName(Types.getPackage((String)qualifiedName));
        }
        ExecutionStatistics.get().end("JavaClassService.getOrCreate(qualifiedName)");
        return clz;
    }

    public Iterable<JavaClassModel> findByJavaClassPattern(String regex) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaClassPattern(regex)");
        Iterable result = super.findAllByPropertyMatchingRegex("qualifiedName", new String[]{regex});
        ExecutionStatistics.get().end("JavaClassService.findByJavaClassPattern(regex)");
        return result;
    }

    public Iterable<JavaClassModel> findByJavaPackage(String packageName) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaPackage(packageName)");
        Iterable result = this.getGraphContext().getQuery().type(JavaClassModel.class).has("packageName", (Object)packageName).vertices(this.getType());
        ExecutionStatistics.get().end("JavaClassService.findByJavaPackage(packageName)");
        return result;
    }

    public Iterable<JavaClassModel> findByJavaVersion(JavaVersion version) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaVersion(version)");
        Iterable result = this.getGraphContext().getQuery().type(JavaClassModel.class).has("majorVersion", (Object)version.getMajor()).has("minorVersion", (Object)version.getMinor()).vertices(this.getType());
        ExecutionStatistics.get().end("JavaClassService.findByJavaVersion(version)");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassModel resolveByQualifiedName(String qualifiedClassName) {
        ExecutionStatistics.get().begin("JavaClassService.resolveByQualifiedName(qualifiedClassName)");
        try {
            JavaClassModel model;
            JavaClassModel javaClassModel = model = (JavaClassModel)this.getUniqueByProperty("qualifiedName", qualifiedClassName);
            return javaClassModel;
        }
        catch (NonUniqueResultException e) {
            Iterable candidates = this.findAllByProperty("qualifiedName", qualifiedClassName);
            for (JavaClassModel candidate : candidates) {
                if (!(candidate instanceof AmbiguousJavaClassModel)) continue;
                JavaClassModel javaClassModel = candidate;
                return javaClassModel;
            }
            GraphService ambiguousJavaClassModelService = new GraphService(this.getGraphContext(), AmbiguousJavaClassModel.class);
            AmbiguousJavaClassModel ambiguousModel = (AmbiguousJavaClassModel)ambiguousJavaClassModelService.create();
            for (JavaClassModel candidate : candidates) {
                ambiguousModel.setSimpleName(Types.toSimpleName((String)qualifiedClassName));
                ambiguousModel.setPackageName(Types.getPackage((String)qualifiedClassName));
                ambiguousModel.setQualifiedName(qualifiedClassName);
                ambiguousModel.addReference(candidate);
            }
            AmbiguousJavaClassModel ambiguousJavaClassModel = ambiguousModel;
            return ambiguousJavaClassModel;
        }
        finally {
            ExecutionStatistics.get().end("JavaClassService.resolveByQualifiedName(qualifiedClassName)");
        }
    }

    public JavaMethodModel addJavaMethod(JavaClassModel jcm, String methodName, JavaClassModel[] params) {
        ExecutionStatistics.get().begin("JavaClassService.addJavaMethod(jcm, methodName, params)");
        JavaMethodModel javaMethodModel = (JavaMethodModel)this.getGraphContext().getFramed().addVertex(null, JavaMethodModel.class);
        javaMethodModel.setMethodName(methodName);
        for (int i = 0; i < params.length; ++i) {
            JavaClassModel param = params[i];
            JavaParameterModel paramModel = (JavaParameterModel)this.getGraphContext().getFramed().addVertex(null, JavaParameterModel.class);
            paramModel.setJavaType(param);
            paramModel.setPosition(i);
            javaMethodModel.addMethodParameter(paramModel);
        }
        jcm.addJavaMethod(javaMethodModel);
        ExecutionStatistics.get().end("JavaClassService.addJavaMethod(jcm, methodName, params)");
        return javaMethodModel;
    }

    public static enum JavaVersion {
        JAVA_8(8, 0),
        JAVA_7(7, 0),
        JAVA_6(6, 0),
        JAVA_5(5, 0),
        JAVA_1_4(1, 4),
        JAVA_1_3(1, 3),
        JAVA_1_2(1, 2),
        JAVA_1_1(1, 1);

        final int major;
        final int minor;

        private JavaVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

