/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.Comparator;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ValueComparator
implements Comparator<Value> {
    private static final ValueComparator INSTANCE = new ValueComparator();
    public static final int BEFORE = -1;
    public static final int EQUALS = 0;
    public static final int AFTER = 1;

    public static final ValueComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Value first, Value second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        if (first == second || first.equals(second)) {
            return 0;
        }
        if (first instanceof BNode) {
            if (second instanceof BNode) {
                return ((BNode)first).getID().compareTo(((BNode)second).getID());
            }
            return -1;
        }
        if (second instanceof BNode) {
            return 1;
        }
        if (first instanceof URI) {
            if (second instanceof URI) {
                return ((URI)first).stringValue().compareTo(((URI)second).stringValue());
            }
            return -1;
        }
        if (second instanceof URI) {
            return 1;
        }
        Literal firstLiteral = (Literal)first;
        Literal secondLiteral = (Literal)second;
        int cmp = firstLiteral.getLabel().compareTo(secondLiteral.getLabel());
        if (0 == cmp) {
            String firstLang = firstLiteral.getLanguage();
            String secondLang = secondLiteral.getLanguage();
            if (null != firstLang) {
                if (null != secondLang) {
                    return firstLang.compareTo(secondLang);
                }
                return 1;
            }
            if (null != secondLang) {
                return -1;
            }
            URI firstType = firstLiteral.getDatatype();
            URI secondType = secondLiteral.getDatatype();
            if (null == firstType) {
                if (null == secondType) {
                    return 0;
                }
                return -1;
            }
            if (null == secondType) {
                return 1;
            }
            return firstType.stringValue().compareTo(secondType.stringValue());
        }
        return cmp;
    }
}

