/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import javax.inject.Inject;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.predicate.NonGUIEnabledPredicate;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.versions.Version;

public class AboutCommand {
    @Inject
    Furnace furnace;

    @Command(value="version", help="Displays the current Forge version.", enabled={NonGUIEnabledPredicate.class})
    public void showVersion(UIOutput output) {
        Version version = this.furnace.getVersion();
        output.out().println("JBoss Forge, version [ " + version + " ] - JBoss, by Red Hat, Inc. [ http://jboss.org/forge ]");
    }

    @Command(value="about", help="Display information about this forge.", enabled={NonGUIEnabledPredicate.class})
    public void showAbout(UIOutput output) {
        output.out().println();
        output.out().println("    _____                    ");
        output.out().println("   |  ___|__  _ __ __ _  ___ ");
        output.out().println("   | |_ / _ \\| `__/ _` |/ _ \\  \\\\");
        output.out().println("   |  _| (_) | | | (_| |  __/  //");
        output.out().println("   |_|  \\___/|_|  \\__, |\\___| ");
        output.out().println("                   |___/      ");
        output.out().println("");
        this.showVersion(output);
    }
}

