/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.shell.util.CommandControllerComparator;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.CommandControllerFactory;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.progress.DefaultUIProgressMonitor;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class CommandListCommand
extends AbstractShellCommand {
    private final CommandFactory commandFactory;
    private final CommandControllerFactory factory;

    @Inject
    public CommandListCommand(CommandFactory commandFactory, CommandControllerFactory factory) {
        this.commandFactory = commandFactory;
        this.factory = factory;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("command-list").description("List all available commands.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Shell shell = (Shell)context.getUIContext().getProvider();
        TerminalSize terminalSize = shell.getConsole().getShell().getSize();
        ArrayList<String> display = new ArrayList<String>();
        TreeSet<CommandController> controllers = new TreeSet<CommandController>(new CommandControllerComparator());
        for (UICommand command : this.commandFactory.getCommands()) {
            controllers.add(this.getCommandController(context, command));
        }
        for (CommandController controller : controllers) {
            String name = this.commandFactory.getCommandName(context.getUIContext(), controller.getCommand());
            UICommandMetadata metadata = controller.getMetadata();
            display.add(metadata.getCategory() + " > " + new TerminalString(name, new TerminalColor(controller.isEnabled() ? Color.CYAN : Color.RED, Color.DEFAULT)).toString() + " - " + metadata.getDescription());
        }
        UIOutput output = context.getUIContext().getProvider().getOutput();
        PrintStream out = output.out();
        out.println(Parser.formatDisplayList((String[])display.toArray(new String[display.size()]), (int)terminalSize.getHeight(), (int)terminalSize.getWidth()));
        return Results.success();
    }

    private CommandController getCommandController(UIExecutionContext context, UICommand command) {
        return this.factory.createController(context.getUIContext(), new UIRuntime(){

            public UIProgressMonitor createProgressMonitor(UIContext context) {
                return new DefaultUIProgressMonitor();
            }

            public UIPrompt createPrompt(UIContext context) {
                return null;
            }
        }, command);
    }
}

