/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.events.ResourceCreated;
import org.jboss.forge.addon.resource.events.ResourceDeleted;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.transaction.ResourceTransaction;
import org.jboss.forge.addon.shell.command.transaction.AggregateChangesTransactionListener;
import org.jboss.forge.addon.shell.command.transaction.OtherTransactionStartedListener;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;

public class AutomaticTransactionCommandListener
implements CommandExecutionListener {
    private final ResourceFactory factory;
    private final OtherTransactionStartedListener otherTransactionListener;
    private final AggregateChangesTransactionListener aggregator;

    public AutomaticTransactionCommandListener(ResourceFactory factory, OtherTransactionStartedListener otherTransactionListener, AggregateChangesTransactionListener aggregator) {
        this.factory = factory;
        this.otherTransactionListener = otherTransactionListener;
        this.aggregator = aggregator;
    }

    public void preCommandExecuted(UICommand command, UIExecutionContext context) {
        ResourceTransaction transaction = this.factory.getTransaction();
        if (!transaction.isStarted()) {
            this.otherTransactionListener.disable();
            transaction.begin();
            this.otherTransactionListener.enable();
        }
    }

    public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
        ResourceTransaction transaction = this.factory.getTransaction();
        if (!this.otherTransactionListener.isInForeignTransaction()) {
            if (result instanceof Failed) {
                if (transaction.isStarted()) {
                    transaction.rollback();
                }
            } else {
                if (transaction.isStarted()) {
                    transaction.commit();
                }
                ArrayList<ResourceEvent> events = new ArrayList<ResourceEvent>(this.aggregator.getResourceEvents());
                this.aggregator.clear();
                Collections.sort(events, new Comparator<ResourceEvent>(){

                    @Override
                    public int compare(ResourceEvent left, ResourceEvent right) {
                        return left.getResource().getFullyQualifiedName().compareTo(right.getResource().getFullyQualifiedName());
                    }
                });
                Map<EventType, Set<String>> organizedEvents = this.organize(events);
                UIOutput output = context.getUIContext().getProvider().getOutput();
                block5: for (Map.Entry<EventType, Set<String>> entry : organizedEvents.entrySet()) {
                    switch (entry.getKey()) {
                        case CREATED: {
                            for (String resourceName : entry.getValue()) {
                                output.out().println("Created  " + resourceName);
                            }
                            continue block5;
                        }
                        case DELETED: {
                            for (String resourceName : entry.getValue()) {
                                output.out().println("Deleted  " + resourceName);
                            }
                            continue block5;
                        }
                        case MODIFIED: {
                            for (String resourceName : entry.getValue()) {
                                output.out().println("Modified " + resourceName);
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    public void postCommandFailure(UICommand command, UIExecutionContext context, Throwable failure) {
        ResourceTransaction transaction = this.factory.getTransaction();
        if (transaction.isStarted()) {
            transaction.rollback();
        }
    }

    private Map<EventType, Set<String>> organize(Iterable<ResourceEvent> events) {
        HashMap<EventType, Set<String>> result = new HashMap<EventType, Set<String>>();
        for (ResourceEvent e : events) {
            Resource resource = e.getResource();
            EventType eventType = e instanceof ResourceCreated ? EventType.CREATED : (e instanceof ResourceDeleted ? EventType.DELETED : EventType.MODIFIED);
            TreeSet<String> list = (TreeSet<String>)result.get((Object)eventType);
            if (list == null) {
                list = new TreeSet<String>();
                result.put(eventType, list);
            }
            list.add(resource.getFullyQualifiedName());
        }
        Set createdResources = (Set)result.get((Object)EventType.CREATED);
        Set modifiedResource = (Set)result.get((Object)EventType.MODIFIED);
        Set deletedResources = (Set)result.get((Object)EventType.DELETED);
        if (modifiedResource != null) {
            Iterator it = modifiedResource.iterator();
            while (it.hasNext()) {
                String resource = (String)it.next();
                if ((createdResources == null || !createdResources.contains(resource)) && (deletedResources == null || !deletedResources.contains(resource))) continue;
                it.remove();
            }
        }
        return result;
    }

    private static enum EventType {
        CREATED,
        DELETED,
        MODIFIED;

    }
}

