/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import java.util.TreeSet;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.shell.CommandNotFoundListener;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.output.UIOutput;

public class DidYouMeanCommandNotFoundListener
implements CommandNotFoundListener {
    private static final int LETTERS_NEEDED_TO_BE_REPLACED = 2;
    private final CommandRegistry commandRegistry;

    public DidYouMeanCommandNotFoundListener(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public void onCommandNotFound(String line, UIContext context) {
        UIOutput output = context.getProvider().getOutput();
        String commandName = line.split(" ")[0];
        TreeSet<String> similarCommands = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String command : this.commandRegistry.getAllCommandNames()) {
            if (DidYouMeanCommandNotFoundListener.getLevenshteinDistance(commandName, command) >= 2) continue;
            similarCommands.add(command);
        }
        if (!similarCommands.isEmpty()) {
            output.out().println();
            if (similarCommands.size() == 1) {
                output.out().println("Did you mean this?");
            } else {
                output.out().println("Did you mean one of these?");
            }
            for (String plugin : similarCommands) {
                output.out().println(new TerminalString("\t" + plugin, new TerminalColor(Color.DEFAULT, Color.DEFAULT, Color.Intensity.BRIGHT)));
            }
        }
    }

    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }
}

