/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.impl;

import java.lang.reflect.Method;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.xadisk.bridge.proxies.facilitators.MethodSerializabler;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.facilitators.RemoteObjectProxy;
import org.xadisk.bridge.proxies.facilitators.SerializedMethod;
import org.xadisk.bridge.proxies.impl.RemoteEventProcessingXAResource;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpoint;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.filesystem.NativeXAFileSystem;

public class RemoteMessageEndpointFactory
extends RemoteObjectProxy
implements MessageEndpointFactory {
    private static final long serialVersionUID = 1L;
    private final String xaDiskSystemId;
    private transient NativeXAFileSystem localXAFileSystem;

    public RemoteMessageEndpointFactory(long objectId, String xaDiskSystemId, RemoteMethodInvoker invoker) {
        super(objectId, invoker);
        this.xaDiskSystemId = xaDiskSystemId;
    }

    public void setLocalXAFileSystem(NativeXAFileSystem localXAFileSystem) {
        this.localXAFileSystem = localXAFileSystem;
    }

    public synchronized boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        try {
            SerializedMethod serializableMethod = new MethodSerializabler().serialize(method);
            return (Boolean)this.invokeRemoteMethod("isDeliveryTransacted", serializableMethod);
        }
        catch (NoSuchMethodException nsme) {
            throw nsme;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public synchronized MessageEndpoint createEndpoint(XAResource xar) throws UnavailableException {
        try {
            GlobalHostedContext globalCallbackContext = this.localXAFileSystem.getGlobalCallbackContext();
            long objectId = globalCallbackContext.hostObject(xar);
            RemoteEventProcessingXAResource remoteEventProcessingXAResource = new RemoteEventProcessingXAResource(objectId, this.localXAFileSystem.createRemoteMethodInvokerToSelf());
            RemoteMessageEndpoint remoteMEP = (RemoteMessageEndpoint)this.invokeRemoteMethod("createEndpoint", remoteEventProcessingXAResource);
            remoteMEP.setInvoker(this.invoker.makeCopy());
            return remoteMEP;
        }
        catch (UnavailableException ue) {
            throw ue;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void shutdown() {
        this.disconnect();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteMessageEndpointFactory) {
            RemoteMessageEndpointFactory that = (RemoteMessageEndpointFactory)obj;
            return this.remoteObjectId == that.remoteObjectId && this.xaDiskSystemId.equals(that.xaDiskSystemId);
        }
        return false;
    }

    public int hashCode() {
        return this.xaDiskSystemId.hashCode() + (int)this.remoteObjectId;
    }

    public String getXaDiskSystemId() {
        return this.xaDiskSystemId;
    }

    public long getRemoteObjectId() {
        return this.remoteObjectId;
    }

    public RemoteMethodInvoker getInvoker() {
        return this.invoker;
    }
}

