/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector.inbound;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.xadisk.filesystem.FileSystemStateChangeEvent;

public class XADiskActivationSpecImpl
implements ActivationSpec,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResourceAdapter ra;
    private final HashMap<File, String> fileNamesAndInterests = new HashMap(10);
    private static final String interestSymbol = "::";
    private static final String seperator = "\\|";
    private String fileNamesAndEventInterests;
    private Boolean areFilesRemote;
    private String remoteServerAddress;
    private Integer remoteServerPort;

    public void setFileNamesAndEventInterests(String filesNamesAndEventInterests) {
        this.fileNamesAndEventInterests = filesNamesAndEventInterests;
        this.setupFileNamesAndEventInterests(filesNamesAndEventInterests.split(seperator));
    }

    public String getFileNamesAndEventInterests() {
        return this.fileNamesAndEventInterests;
    }

    public String getAreFilesRemote() {
        return this.areFilesRemote.toString();
    }

    public void setAreFilesRemote(String areFilesRemote) {
        this.areFilesRemote = Boolean.valueOf(areFilesRemote);
    }

    public String getRemoteServerAddress() {
        return this.remoteServerAddress;
    }

    public void setRemoteServerAddress(String remoteServerAddress) {
        this.remoteServerAddress = remoteServerAddress;
    }

    public String getRemoteServerPort() {
        return this.remoteServerPort.toString();
    }

    public void setRemoteServerPort(String remoteServerPort) {
        this.remoteServerPort = new Integer(remoteServerPort);
    }

    private void setupFileNamesAndEventInterests(String[] fileNamesAndEventInterest) {
        this.fileNamesAndInterests.clear();
        for (int i = 0; i < fileNamesAndEventInterest.length; ++i) {
            String[] temp = fileNamesAndEventInterest[i].split(interestSymbol);
            this.fileNamesAndInterests.put(new File(temp[0]), temp[1]);
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.ra = ra;
    }

    public void validate() throws InvalidPropertyException {
        for (String interest : this.fileNamesAndInterests.values()) {
            try {
                Integer.valueOf(interest);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidPropertyException("Invalid event-interest specification : " + interest);
            }
        }
    }

    public boolean isEndpointInterestedIn(FileSystemStateChangeEvent event) {
        byte queriedInterest;
        byte interestedBits;
        String interested = this.fileNamesAndInterests.get(event.getFile());
        return interested != null && ((interestedBits = Byte.parseByte(interested, 2)) & (queriedInterest = event.getEventType().getByteValue())) > 0;
    }
}

