/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.pools;

import java.nio.ByteBuffer;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.pools.PooledResource;

public class PooledBuffer
extends Buffer
implements PooledResource {
    private volatile long lastFreed = -1L;

    PooledBuffer(int bufferSize, boolean isDirect, NativeXAFileSystem xaFileSystem) {
        super(bufferSize, isDirect, xaFileSystem);
    }

    public void markFree() {
        this.buffer.clear();
        this.lastFreed = System.currentTimeMillis() / 1000L;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getLastFreed() {
        return this.lastFreed;
    }
}

