/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.utilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.TransactionInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogsUtility {
    public static void addLogPositionToTransaction(TransactionInformation xid, int logFileIndex, long localPosition, Map<TransactionInformation, ArrayList<Long>> transactionLogPositions) {
        ArrayList<Long> temp = transactionLogPositions.get(xid);
        if (temp == null) {
            temp = new ArrayList(25);
            transactionLogPositions.put(xid, temp);
        }
        temp.add(Long.valueOf(logFileIndex));
        temp.add(localPosition);
    }

    public static void deleteLogsIfPossible(TransactionInformation xid, Map<TransactionInformation, ArrayList<Integer>> transactionsAndLogsOccupied, Map<Integer, Integer> transactionLogsAndOpenTransactions, int currentLogIndex, String transactionLogBaseName, DurableDiskSession durableDiskSession) throws IOException {
        ArrayList<Integer> logsOccupied = transactionsAndLogsOccupied.get(xid);
        if (logsOccupied == null) {
            return;
        }
        for (Integer logFileIndex : logsOccupied) {
            Integer numTxns;
            Integer n = numTxns = transactionLogsAndOpenTransactions.get(logFileIndex);
            Integer n2 = numTxns = Integer.valueOf(numTxns - 1);
            if (numTxns == 0 && currentLogIndex != logFileIndex) {
                durableDiskSession.deleteFileDurably(new File(transactionLogBaseName + "_" + logFileIndex));
                continue;
            }
            transactionLogsAndOpenTransactions.put(logFileIndex, numTxns);
        }
    }

    public static void trackTransactionLogsUsage(TransactionInformation xid, Map<TransactionInformation, ArrayList<Integer>> transactionsAndLogsOccupied, Map<Integer, Integer> transactionLogsAndOpenTransactions, int logFileIndex) {
        boolean txnFirstTimeInThisLog = false;
        ArrayList<Integer> logsOccupied = transactionsAndLogsOccupied.get(xid);
        if (logsOccupied == null) {
            logsOccupied = new ArrayList(2);
            transactionsAndLogsOccupied.put(xid, logsOccupied);
        }
        if (!logsOccupied.contains(logFileIndex)) {
            logsOccupied.add(logFileIndex);
            txnFirstTimeInThisLog = true;
        }
        if (txnFirstTimeInThisLog) {
            Integer numTxns = transactionLogsAndOpenTransactions.get(logFileIndex);
            if (numTxns == null) {
                numTxns = 0;
            }
            Integer n = numTxns;
            Integer n2 = numTxns = Integer.valueOf(numTxns + 1);
            transactionLogsAndOpenTransactions.put(logFileIndex, numTxns);
        }
    }
}

