/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.pools.ResourcePool;
import org.xadisk.filesystem.workers.TimedWorker;

public class ObjectPoolReliever
extends TimedWorker {
    private final ResourcePool objectPool;
    private final NativeXAFileSystem xaFileSystem;

    public ObjectPoolReliever(ResourcePool objectPool, int frequency, NativeXAFileSystem xaFileSystem) {
        super(frequency);
        this.objectPool = objectPool;
        this.xaFileSystem = xaFileSystem;
    }

    void doWorkOnce() {
        try {
            this.objectPool.freeIdleMembers();
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
    }

    public void release() {
        super.release();
    }

    public void run() {
        super.run();
    }
}

