/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import java.util.List;

final class ParameterizedType
extends TypeReference
implements IGenericInstance {
    private final TypeReference _genericDefinition;
    private final List<TypeReference> _typeParameters;

    ParameterizedType(TypeReference genericDefinition, List<TypeReference> typeParameters) {
        this._genericDefinition = genericDefinition;
        this._typeParameters = typeParameters;
    }

    private void exitIfNeeded() {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Thread interrupted... exiting");
        }
    }

    public String getName() {
        this.exitIfNeeded();
        return this._genericDefinition.getName();
    }

    public String getPackageName() {
        this.exitIfNeeded();
        return this._genericDefinition.getPackageName();
    }

    public String getFullName() {
        this.exitIfNeeded();
        return this._genericDefinition.getFullName();
    }

    public String getInternalName() {
        this.exitIfNeeded();
        return this._genericDefinition.getInternalName();
    }

    public TypeReference getDeclaringType() {
        this.exitIfNeeded();
        return this._genericDefinition.getDeclaringType();
    }

    public String getSimpleName() {
        this.exitIfNeeded();
        return this._genericDefinition.getSimpleName();
    }

    public boolean isGenericDefinition() {
        this.exitIfNeeded();
        return false;
    }

    public List<GenericParameter> getGenericParameters() {
        TypeDefinition resolvedDefinition;
        this.exitIfNeeded();
        if (!this._genericDefinition.isGenericDefinition() && (resolvedDefinition = this._genericDefinition.resolve()) != null) {
            return resolvedDefinition.getGenericParameters();
        }
        return this._genericDefinition.getGenericParameters();
    }

    public boolean hasTypeArguments() {
        this.exitIfNeeded();
        return true;
    }

    public List<TypeReference> getTypeArguments() {
        this.exitIfNeeded();
        return this._typeParameters;
    }

    public IGenericParameterProvider getGenericDefinition() {
        this.exitIfNeeded();
        return this._genericDefinition;
    }

    public TypeReference getUnderlyingType() {
        this.exitIfNeeded();
        return this._genericDefinition;
    }

    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        this.exitIfNeeded();
        return (R)visitor.visitParameterizedType((TypeReference)this, parameter);
    }

    public TypeDefinition resolve() {
        this.exitIfNeeded();
        return this._genericDefinition.resolve();
    }

    public FieldDefinition resolve(FieldReference field) {
        this.exitIfNeeded();
        return this._genericDefinition.resolve(field);
    }

    public MethodDefinition resolve(MethodReference method) {
        this.exitIfNeeded();
        return this._genericDefinition.resolve(method);
    }

    public TypeDefinition resolve(TypeReference type) {
        this.exitIfNeeded();
        return this._genericDefinition.resolve(type);
    }
}

