/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.ContextUnit;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class StructContext {
    private final IResultSaver saver;
    private final IDecompiledData decompiledData;
    private final LazyLoader loader;
    private final Map<String, ContextUnit> units = new HashMap<String, ContextUnit>();
    private final Map<String, StructClass> classes = new HashMap<String, StructClass>();

    public StructContext(IResultSaver saver, IDecompiledData decompiledData, LazyLoader loader) {
        this.saver = saver;
        this.decompiledData = decompiledData;
        this.loader = loader;
        ContextUnit defaultUnit = new ContextUnit(0, null, "", true, saver, decompiledData);
        this.units.put("", defaultUnit);
    }

    public StructClass getClass(String name) {
        return this.classes.get(name);
    }

    public void reloadContext() throws IOException {
        for (ContextUnit unit : this.units.values()) {
            for (StructClass cl : unit.getClasses()) {
                this.classes.remove(cl.qualifiedName);
            }
            unit.reload(this.loader);
            for (StructClass cl : unit.getClasses()) {
                this.classes.put(cl.qualifiedName, cl);
            }
        }
    }

    public void saveContext() {
        for (ContextUnit unit : this.units.values()) {
            if (!unit.isOwn()) continue;
            unit.save();
        }
    }

    public void addSpace(File file, boolean isOwn) {
        this.addSpace("", file, isOwn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpace(String path, File file, boolean isOwn, int level) {
        if (file.isDirectory()) {
            if (level == 1) {
                path = path + file.getName();
            } else if (level > 1) {
                path = path + "/" + file.getName();
            }
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = files.length - 1; i >= 0; --i) {
                    this.addSpace(path, files[i], isOwn, level + 1);
                }
            }
        } else {
            String filename = file.getName();
            boolean isArchive = false;
            try {
                if (filename.endsWith(".jar")) {
                    isArchive = true;
                    this.addArchive(path, file, 1, isOwn);
                } else if (filename.endsWith(".zip")) {
                    isArchive = true;
                    this.addArchive(path, file, 2, isOwn);
                }
            }
            catch (IOException ex) {
                String message = "Corrupted archive file: " + file;
                DecompilerContext.getLogger().writeMessage(message, ex);
            }
            if (isArchive) {
                return;
            }
            ContextUnit unit = this.units.get(path);
            if (unit == null) {
                unit = new ContextUnit(0, null, path, isOwn, this.saver, this.decompiledData);
                this.units.put(path, unit);
            }
            if (filename.endsWith(".class")) {
                try (DataInputFullStream in = this.loader.getClassStream(file.getAbsolutePath(), null);){
                    StructClass cl = new StructClass(in, isOwn, this.loader);
                    this.classes.put(cl.qualifiedName, cl);
                    unit.addClass(cl, filename);
                    this.loader.addClassLink(cl.qualifiedName, new LazyLoader.Link(1, file.getAbsolutePath(), null));
                }
                catch (IOException ex) {
                    String message = "Corrupted class file: " + file;
                    DecompilerContext.getLogger().writeMessage(message, ex);
                }
            } else {
                unit.addOtherEntry(file.getAbsolutePath(), filename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArchive(String path, File file, int type, boolean isOwn) throws IOException {
        try (ZipFile archive = type == 1 ? new JarFile(file) : new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                ContextUnit unit = this.units.get(path + "/" + file.getName());
                if (unit == null) {
                    unit = new ContextUnit(type, path, file.getName(), isOwn, this.saver, this.decompiledData);
                    if (type == 1) {
                        unit.setManifest(((JarFile)archive).getManifest());
                    }
                    this.units.put(path + "/" + file.getName(), unit);
                }
                String name = entry.getName();
                if (!entry.isDirectory()) {
                    if (name.endsWith(".class")) {
                        byte[] bytes = InterpreterUtil.getBytes(archive, entry);
                        StructClass cl = new StructClass(bytes, isOwn, this.loader);
                        this.classes.put(cl.qualifiedName, cl);
                        unit.addClass(cl, name);
                        this.loader.addClassLink(cl.qualifiedName, new LazyLoader.Link(2, file.getAbsolutePath(), name));
                        continue;
                    }
                    unit.addOtherEntry(file.getAbsolutePath(), name);
                    continue;
                }
                unit.addDirEntry(name);
            }
        }
    }

    public Map<String, StructClass> getClasses() {
        return this.classes;
    }
}

