/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.util.Version;
import org.apache.maven.index.ArtifactInfo;

public final class NexusLegacyAnalyzer
extends Analyzer {
    private static final Analyzer DEFAULT_ANALYZER = new StandardAnalyzer(Version.LUCENE_46);

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        try {
            return new Analyzer.TokenStreamComponents((Tokenizer)this.tokenizer(fieldName, reader));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected TokenStream tokenizer(String field, Reader reader) throws IOException {
        if (!this.isTextField(field)) {
            return new CharTokenizer(Version.LUCENE_46, reader){

                protected boolean isTokenChar(int c) {
                    return Character.isLetterOrDigit(c);
                }

                protected int normalize(int c) {
                    return Character.toLowerCase(c);
                }
            };
        }
        return DEFAULT_ANALYZER.tokenStream(field, reader);
    }

    protected boolean isTextField(String field) {
        return ArtifactInfo.NAME.equals(field) || ArtifactInfo.DESCRIPTION.equals(field) || ArtifactInfo.NAMES.equals(field);
    }
}

