/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.UpdateContext;

public class SailConnectionWrapper
implements SailConnection {
    private SailConnection wrappedCon;

    public SailConnectionWrapper(SailConnection wrappedCon) {
        this.wrappedCon = wrappedCon;
    }

    public SailConnection getWrappedConnection() {
        return this.wrappedCon;
    }

    @Override
    public boolean isOpen() throws SailException {
        return this.wrappedCon.isOpen();
    }

    @Override
    public void close() throws SailException {
        this.wrappedCon.close();
    }

    @Override
    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        return this.wrappedCon.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    @Override
    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        return this.wrappedCon.getContextIDs();
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        return this.wrappedCon.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public long size(Resource ... contexts) throws SailException {
        return this.wrappedCon.size(contexts);
    }

    public long size(Resource context) throws SailException {
        return this.wrappedCon.size(context);
    }

    @Override
    public void commit() throws SailException {
        this.wrappedCon.commit();
    }

    @Override
    public void rollback() throws SailException {
        this.wrappedCon.rollback();
    }

    @Override
    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.wrappedCon.addStatement(subj, pred, obj, contexts);
    }

    @Override
    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.wrappedCon.removeStatements(subj, pred, obj, contexts);
    }

    @Override
    public void startUpdate(UpdateContext modify) throws SailException {
        this.wrappedCon.startUpdate(modify);
    }

    @Override
    public void addStatement(UpdateContext modify, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.wrappedCon.addStatement(modify, subj, pred, obj, contexts);
    }

    @Override
    public void removeStatement(UpdateContext modify, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.wrappedCon.removeStatement(modify, subj, pred, obj, contexts);
    }

    @Override
    public void endUpdate(UpdateContext modify) throws SailException {
        this.wrappedCon.endUpdate(modify);
    }

    @Override
    public void clear(Resource ... contexts) throws SailException {
        this.wrappedCon.clear(contexts);
    }

    @Override
    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        return this.wrappedCon.getNamespaces();
    }

    @Override
    public String getNamespace(String prefix) throws SailException {
        return this.wrappedCon.getNamespace(prefix);
    }

    @Override
    public void setNamespace(String prefix, String name) throws SailException {
        this.wrappedCon.setNamespace(prefix, name);
    }

    @Override
    public void removeNamespace(String prefix) throws SailException {
        this.wrappedCon.removeNamespace(prefix);
    }

    @Override
    public void clearNamespaces() throws SailException {
        this.wrappedCon.clearNamespaces();
    }

    @Override
    public void begin() throws SailException {
        this.wrappedCon.begin();
    }

    @Override
    public void prepare() throws SailException {
        this.wrappedCon.prepare();
    }

    @Override
    public boolean isActive() throws UnknownSailTransactionStateException {
        return this.wrappedCon.isActive();
    }
}

