/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerTemplateDirective;
import org.jboss.windup.reporting.model.association.LinkableModel;
import org.jboss.windup.util.Logging;

public class LinkableDirective
implements WindupFreeMarkerTemplateDirective {
    private static final Logger LOG = Logging.get(LinkableDirective.class);
    private GraphContext context;

    public String getDescription() {
        return "Takes the following parameters: LinkableModel (a " + LinkableModel.class.getSimpleName() + ")";
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Writer writer = env.getOut();
        StringModel projectStringModel = (StringModel)params.get("linkable");
        Object obj = projectStringModel.getWrappedObject();
        if (!(obj instanceof LinkableModel)) {
            return;
        }
        LayoutType layoutType = LayoutType.HORIZONTAL;
        SimpleScalar layoutModel = (SimpleScalar)params.get("layout");
        if (layoutModel != null) {
            String lt = layoutModel.getAsString();
            try {
                LayoutType.valueOf(lt.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new TemplateException("Layout: " + lt + " is not supported.", (Exception)e, null);
            }
        }
        LinkableModel linkable = (LinkableModel)obj;
        if (layoutType == LayoutType.UL) {
            this.renderAsUL(writer, linkable);
        }
        if (layoutType == LayoutType.LI) {
            this.renderAsLI(writer, linkable);
        } else if (layoutType == LayoutType.DL) {
            this.renderAsDL(writer, linkable);
        } else if (layoutType == LayoutType.DT) {
            this.renderAsDT(writer, linkable);
        } else {
            this.renderAsHorizontal(writer, linkable);
        }
    }

    private void renderAsUL(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            writer.append("<ul>");
            this.renderAsLI(writer, linkable);
            writer.append("</ul>");
        }
    }

    private void renderAsLI(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            while (links.hasNext()) {
                LinkModel link = (LinkModel)links.next();
                writer.append("<li>");
                this.renderLink(writer, link);
                writer.append("</li>");
            }
        }
    }

    private void renderAsDL(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            writer.append("<dl>");
            this.renderAsDT(writer, linkable);
            writer.append("</dl>");
        }
    }

    private void renderAsDT(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            while (links.hasNext()) {
                LinkModel link = (LinkModel)links.next();
                writer.append("<dt>");
                writer.append(link.getDescription());
                writer.append("</dt>");
                writer.append("<dd>");
                writer.append("<a href='" + link.getLink() + "'>Link</a>");
                writer.append("</dd>");
            }
        }
    }

    private void renderAsHorizontal(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        while (links.hasNext()) {
            LinkModel link = (LinkModel)links.next();
            this.renderLink(writer, link);
            if (!links.hasNext()) continue;
            writer.append(" | ");
        }
    }

    private void renderLink(Writer writer, LinkModel link) throws IOException {
        writer.append("<a href='" + link.getLink() + "'>");
        writer.append(link.getDescription());
        writer.append("</a>");
    }

    public String getDirectiveName() {
        return "render_linkable";
    }

    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    private static enum LayoutType {
        HORIZONTAL,
        UL,
        DL,
        LI,
        DT;

    }
}

