/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.util.Logging;

public final class TypeInterestFactory {
    private static Logger LOG = Logging.get(TypeInterestFactory.class);
    private static Map<String, PatternAndLocation> patternsBySource = new HashMap<String, PatternAndLocation>();
    private static Map<TypeReferenceLocation, Map<String, Pattern>> patternsByLocation = new HashMap<TypeReferenceLocation, Map<String, Pattern>>();
    private static Set<String> ignorePatternSet = Collections.synchronizedSet(new HashSet());
    private static Map<String, Boolean> resultsCache;
    private static AtomicLong cacheLookupCount;
    private static AtomicLong cacheHitCount;
    private static Set<String> prescanMap;
    private static AtomicInteger totalPrescans;
    private static AtomicInteger totalPrescanHits;

    static void clear() {
        patternsBySource.clear();
        patternsByLocation.clear();
        resultsCache.clear();
        cacheLookupCount.set(0L);
        cacheHitCount.set(0L);
        prescanMap.clear();
        totalPrescans.set(0);
        totalPrescanHits.set(0);
    }

    public static void registerInterest(String sourceKey, String regex, String pattern, List<TypeReferenceLocation> locations) {
        TypeInterestFactory.registerInterest(sourceKey, regex, pattern, locations.toArray(new TypeReferenceLocation[locations.size()]));
    }

    public static void registerInterest(String sourceKey, String regex, String pattern, TypeReferenceLocation ... locations) {
        patternsBySource.put(sourceKey, new PatternAndLocation(locations, regex, pattern));
    }

    private static String getCacheKey(TypeReferenceLocation location, String text) {
        return location + "_" + text;
    }

    private static Boolean checkCacheForMatches(String inputText, TypeReferenceLocation location) {
        String key = TypeInterestFactory.getCacheKey(location, inputText);
        Boolean cachedResult = resultsCache.get(key);
        Long lookupCount = cacheLookupCount.incrementAndGet();
        Long hitCount = cacheHitCount.get();
        if (cachedResult != null) {
            hitCount = cacheHitCount.incrementAndGet();
        }
        if (lookupCount % 100000L == 0L) {
            long hitPercentage = Math.round((double)hitCount.longValue() / (double)lookupCount.longValue() * 100.0);
            LOG.fine("There have been " + lookupCount + " lookups with " + hitCount + " hits, for a hit percentage of: " + hitPercentage);
        }
        return cachedResult;
    }

    private static Map<String, Pattern> getPatternsByLocation(TypeReferenceLocation typeReferenceLocation) {
        Map<String, Pattern> result = patternsByLocation.get(typeReferenceLocation);
        if (result == null) {
            result = new HashMap<String, Pattern>();
            for (PatternAndLocation patternKey : patternsBySource.values()) {
                String entryRegex = patternKey.regex;
                TypeReferenceLocation[] entryLocations = patternKey.locations;
                if (result.containsKey(entryRegex)) continue;
                boolean shouldAdd = false;
                if (entryLocations == null || entryLocations.length == 0) {
                    shouldAdd = true;
                } else {
                    for (TypeReferenceLocation entryLocation : entryLocations) {
                        if (!typeReferenceLocation.equals((Object)entryLocation)) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                result.put(entryRegex, Pattern.compile(".*" + entryRegex + ".*"));
            }
            patternsByLocation.put(typeReferenceLocation, result);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static boolean matchesAny(String text, TypeReferenceLocation typeReferenceLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        ignorePatternSet.add("void");
        ignorePatternSet.add("String");
        ignorePatternSet.add("java.lang.String");
        ignorePatternSet.add("boolean");
        ignorePatternSet.add("Boolean");
        ignorePatternSet.add("java.lang.Boolean");
        ignorePatternSet.add("int");
        ignorePatternSet.add("Integer");
        ignorePatternSet.add("java.lang.Integer");
        ignorePatternSet.add("long");
        ignorePatternSet.add("Long");
        ignorePatternSet.add("java.lang.Long");
        ignorePatternSet.add("double");
        ignorePatternSet.add("Double");
        ignorePatternSet.add("java.lang.Double");
        ignorePatternSet.add("float");
        ignorePatternSet.add("Float");
        ignorePatternSet.add("java.lang.Float");
        resultsCache = Collections.synchronizedMap(new LRUMap(8000));
        cacheLookupCount = new AtomicLong(0L);
        cacheHitCount = new AtomicLong(0L);
        prescanMap = new TreeSet<String>();
        totalPrescans = new AtomicInteger();
        totalPrescanHits = new AtomicInteger();
    }

    private static class PatternAndLocation {
        private TypeReferenceLocation[] locations;
        private String regex;
        private String pattern;

        private PatternAndLocation(TypeReferenceLocation[] locations, String regex, String pattern) {
            this.locations = locations;
            this.regex = regex;
            this.pattern = pattern;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.locations);
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternAndLocation other = (PatternAndLocation)obj;
            if (!Arrays.equals(this.locations, other.locations)) {
                return false;
            }
            return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
        }

        static /* synthetic */ String access$300(PatternAndLocation x0) {
            return x0.pattern;
        }
    }
}

