/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.rules.apps.maven.dao.MavenProjectService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.MarshallingException;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoverMavenProjectsRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverMavenProjectsRuleProvider.class);
    private static final Map<String, String> namespaces = new HashMap<String, String>();

    public DiscoverMavenProjectsRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverMavenProjectsRuleProvider.class).setPhase(DiscoverProjectStructurePhase.class).setHaltOnException(true));
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderWith fileWhen = Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"pom.xml");
        final ClassificationService classificationService = new ClassificationService(context);
        final TechnologyTagService technologyTagService = new TechnologyTagService(context);
        AbstractIterationOperation<XmlFileModel> evaluatePomFiles = new AbstractIterationOperation<XmlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
                block3: {
                    MavenProjectModel mavenProjectModel;
                    block4: {
                        if (payload.getProjectModel() != null) {
                            return;
                        }
                        String defaultName = payload.getParentArchive() == null ? payload.asFile().getParentFile().getName() : payload.getParentArchive().getFileName();
                        mavenProjectModel = DiscoverMavenProjectsRuleProvider.this.extractMavenProjectModel(event, defaultName, payload);
                        if (mavenProjectModel == null) break block3;
                        classificationService.attachClassification((FileModel)payload, "Maven POM", "Maven Project Object Model (POM) File");
                        technologyTagService.addTagToFileModel((FileModel)payload, "Maven XML", TechnologyTagLevel.INFORMATIONAL);
                        ArchiveModel archiveModel = payload.getParentArchive();
                        if (archiveModel == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject((FileModel)archiveModel)) break block4;
                        archiveModel.setProjectModel((ProjectModel)mavenProjectModel);
                        mavenProjectModel.setRootFileModel((FileModel)archiveModel);
                        for (FileModel f : archiveModel.getContainedFileModels()) {
                            if (f instanceof ArchiveModel || f.getProjectModel() != null) continue;
                            f.setProjectModel((ProjectModel)mavenProjectModel);
                            mavenProjectModel.addFileModel(f);
                        }
                        break block3;
                    }
                    File parentFile = payload.asFile().getParentFile();
                    FileModel parentFileModel = new FileService(event.getGraphContext()).findByPath(parentFile.getAbsolutePath());
                    if (parentFileModel == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject(parentFileModel)) break block3;
                    parentFileModel.setProjectModel((ProjectModel)mavenProjectModel);
                    mavenProjectModel.addFileModel(parentFileModel);
                    mavenProjectModel.setRootFileModel(parentFileModel);
                    for (FileModel childFile : parentFileModel.getFilesInDirectory()) {
                        DiscoverMavenProjectsRuleProvider.this.addFilesToModel(mavenProjectModel, childFile);
                    }
                }
            }

            public String toString() {
                return "ScanMavenProject";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)fileWhen).perform((Operation)evaluatePomFiles);
    }

    private boolean isAlreadyMavenProject(FileModel fileModel) {
        return fileModel.getProjectModel() != null && fileModel.getProjectModel() instanceof MavenProjectModel;
    }

    private void addFilesToModel(MavenProjectModel mavenProjectModel, FileModel fileModel) {
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            String filename = childFile.getFileName();
            if (!filename.equals("pom.xml")) continue;
            return;
        }
        fileModel.setProjectModel((ProjectModel)mavenProjectModel);
        mavenProjectModel.addFileModel(fileModel);
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            this.addFilesToModel(mavenProjectModel, childFile);
        }
    }

    public MavenProjectModel extractMavenProjectModel(GraphRewrite event, String defaultProjectName, XmlFileModel xmlFileModel) {
        MavenProjectService mavenProjectService;
        MavenProjectModel mavenProjectModel;
        File xmlFile = xmlFileModel.asFile();
        Document document = new XmlFileService(event.getGraphContext()).loadDocumentQuiet(xmlFileModel);
        if (document == null) {
            LOG.warning("Could not parse pom at: " + xmlFileModel.getFilePath() + " skipping maven project discovery for this.");
            return null;
        }
        String modelVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:modelVersion", namespaces);
        String name = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:name", namespaces);
        String organization = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:organization", namespaces);
        String description = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:description", namespaces);
        String url = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:url", namespaces);
        String groupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:groupId", namespaces);
        String artifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:artifactId", namespaces);
        String version = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:version", namespaces);
        String parentGroupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:groupId", namespaces);
        String parentArtifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:artifactId", namespaces);
        String parentVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:version", namespaces);
        if (StringUtils.isBlank((String)groupId) && StringUtils.isNotBlank((String)parentGroupId)) {
            groupId = parentGroupId;
        }
        if (StringUtils.isBlank((String)version) && StringUtils.isNotBlank((String)parentVersion)) {
            version = parentVersion;
        }
        if (StringUtils.isBlank((String)organization)) {
            organization = PackageNameMapping.getOrganizationForPackage(event, groupId);
        }
        if ((mavenProjectModel = this.getMavenStubProject(mavenProjectService = new MavenProjectService(event.getGraphContext()), groupId, artifactId, version)) == null) {
            LOG.info("Creating maven project for pom at: " + xmlFileModel.getFilePath() + " with gav: " + groupId + "," + artifactId + "," + version);
            mavenProjectModel = mavenProjectService.createMavenStub(groupId, artifactId, version);
            mavenProjectModel.addMavenPom(xmlFileModel);
        } else {
            boolean found = false;
            for (XmlFileModel foundPom : mavenProjectModel.getMavenPom()) {
                File foundPomFile = foundPom.asFile();
                if (!foundPomFile.getAbsoluteFile().equals(xmlFile)) continue;
                found = true;
                break;
            }
            if (!found) {
                mavenProjectModel.addMavenPom(xmlFileModel);
            }
        }
        if (StringUtils.isBlank((String)name)) {
            name = defaultProjectName;
        }
        mavenProjectModel.setName(this.getReadableNameForProject(name, groupId, artifactId, version));
        if (StringUtils.isNotBlank((String)organization)) {
            mavenProjectModel.setOrganization(organization);
        }
        if (StringUtils.isNotBlank((String)description)) {
            mavenProjectModel.setDescription(StringUtils.trim((String)description));
        }
        if (StringUtils.isNotBlank((String)url)) {
            mavenProjectModel.setURL(StringUtils.trim((String)url));
        }
        if (StringUtils.isNotBlank((String)modelVersion)) {
            mavenProjectModel.setSpecificationVersion(modelVersion);
        }
        if (StringUtils.isNotBlank((String)parentGroupId)) {
            MavenProjectModel parent = this.getMavenProject(mavenProjectService, parentGroupId = this.resolveProperty(document, namespaces, parentGroupId, version), parentArtifactId = this.resolveProperty(document, namespaces, parentArtifactId, version), parentVersion = this.resolveProperty(document, namespaces, parentVersion, version));
            if (parent == null) {
                parent = mavenProjectService.createMavenStub(parentGroupId, parentArtifactId, parentVersion);
                parent.setName(this.getReadableNameForProject(null, parentGroupId, parentArtifactId, parentVersion));
            }
            mavenProjectModel.setParentMavenPOM(parent);
        }
        NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)"/pom:project/pom:dependencies/pom:dependency", namespaces);
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = nodes.item(i);
            String dependencyGroupId = XmlUtil.xpathExtract((Node)node, (String)"./pom:groupId", namespaces);
            String dependencyArtifactId = XmlUtil.xpathExtract((Node)node, (String)"./pom:artifactId", namespaces);
            String dependencyVersion = XmlUtil.xpathExtract((Node)node, (String)"./pom:version", namespaces);
            String dependencyClassifier = XmlUtil.xpathExtract((Node)node, (String)"./pom:classifier", namespaces);
            String dependencyScope = XmlUtil.xpathExtract((Node)node, (String)"./pom:scope", namespaces);
            String dependencyType = XmlUtil.xpathExtract((Node)node, (String)"./pom:type", namespaces);
            dependencyGroupId = this.resolveProperty(document, namespaces, dependencyGroupId, version);
            dependencyArtifactId = this.resolveProperty(document, namespaces, dependencyArtifactId, version);
            dependencyVersion = this.resolveProperty(document, namespaces, dependencyVersion, version);
            if (!StringUtils.isNotBlank((String)dependencyGroupId)) continue;
            MavenProjectModel dependency = this.getMavenProject(mavenProjectService, dependencyGroupId, dependencyArtifactId, dependencyVersion);
            if (dependency == null) {
                dependency = mavenProjectService.createMavenStub(dependencyGroupId, dependencyArtifactId, dependencyVersion);
                dependency.setName(this.getReadableNameForProject(null, dependencyGroupId, dependencyArtifactId, dependencyVersion));
            }
            ProjectDependencyModel projectDep = (ProjectDependencyModel)new GraphService(event.getGraphContext(), ProjectDependencyModel.class).create();
            projectDep.setClassifier(dependencyClassifier);
            projectDep.setScope(dependencyScope);
            projectDep.setType(dependencyType);
            projectDep.setProject((ProjectModel)dependency);
            mavenProjectModel.addDependency(projectDep);
        }
        return mavenProjectModel;
    }

    private MavenProjectModel getMavenProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> possibleProjects = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        MavenProjectModel project = null;
        for (MavenProjectModel possibleProject : possibleProjects) {
            if (possibleProject.getRootFileModel() != null) {
                return possibleProject;
            }
            if (project != null) continue;
            project = possibleProject;
        }
        return project;
    }

    private MavenProjectModel getMavenStubProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> mavenProjectModels = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        if (!mavenProjectModels.iterator().hasNext()) {
            return null;
        }
        for (MavenProjectModel mavenProjectModel : mavenProjectModels) {
            if (mavenProjectModel.getRootFileModel() != null) continue;
            return mavenProjectModel;
        }
        return null;
    }

    private String getReadableNameForProject(String mavenName, String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)mavenName)) {
            sb.append(mavenName);
            sb.append(" (");
        }
        if (StringUtils.isNotBlank((String)groupId) || StringUtils.isNotBlank((String)artifactId) || StringUtils.isNotBlank((String)version)) {
            sb.append(groupId).append(":").append(artifactId).append(":").append(version);
        }
        if (StringUtils.isNotBlank((String)mavenName)) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String resolveProperty(Document document, Map<String, String> namespaces, String property, String projectVersion) throws MarshallingException {
        if (StringUtils.startsWith((String)property, (String)"${")) {
            String propertyName = StringUtils.removeStart((String)property, (String)"${");
            switch (propertyName = StringUtils.removeEnd((String)propertyName, (String)"}")) {
                case "pom.version": 
                case "project.version": {
                    return projectVersion;
                }
            }
            NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)("//pom:properties/pom:" + propertyName), namespaces);
            if (nodes.getLength() == 0 || nodes.item(0) == null) {
                LOG.warning("Expected: " + property + " but it wasn't found in the POM.");
            } else {
                Node node = nodes.item(0);
                String value = node.getTextContent();
                return value;
            }
        }
        return property;
    }

    static {
        namespaces.put("pom", "http://maven.apache.org/POM/4.0.0");
    }
}

