/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractTypedRelation;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.StringFactory;

public abstract class AbstractEdge
extends AbstractTypedRelation
implements TitanEdge {
    private InternalVertex start;
    private InternalVertex end;

    public AbstractEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end) {
        super(id, label);
        assert (start != null && end != null);
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public String getLabel() {
        return this.type.getName();
    }

    public void setVertexAt(int pos, InternalVertex vertex) {
        Preconditions.checkArgument((vertex != null && this.getVertex(pos).equals(vertex) ? 1 : 0) != 0);
        switch (pos) {
            case 0: {
                this.start = vertex;
                break;
            }
            case 1: {
                this.end = vertex;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid position: " + pos);
            }
        }
    }

    @Override
    public InternalVertex getVertex(int pos) {
        switch (pos) {
            case 0: {
                return this.start;
            }
            case 1: {
                return this.end;
            }
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public int getLen() {
        assert (!this.type.isUnidirected(Direction.IN));
        return this.isUnidirected() ? 1 : 2;
    }

    @Override
    public EdgeLabel getEdgeLabel() {
        return (EdgeLabel)((Object)this.type);
    }

    @Override
    public TitanVertex getVertex(Direction dir) {
        return this.getVertex(EdgeDirection.position(dir));
    }

    @Override
    public TitanVertex getOtherVertex(TitanVertex vertex) {
        if (this.start.equals(vertex)) {
            return this.end;
        }
        if (this.end.equals(vertex)) {
            return this.start;
        }
        throw new IllegalArgumentException("Edge is not incident on vertex");
    }

    @Override
    public boolean isDirected() {
        return ((EdgeLabel)((Object)this.type)).isDirected();
    }

    @Override
    public boolean isUnidirected() {
        return ((EdgeLabel)((Object)this.type)).isUnidirected();
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public boolean isEdge() {
        return true;
    }
}

