/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndexField {
    private final PropertyKey key;

    IndexField(PropertyKey key) {
        Preconditions.checkNotNull((Object)key);
        this.key = key;
    }

    public PropertyKey getFieldKey() {
        return this.key;
    }

    public static IndexField of(PropertyKey key) {
        return new IndexField(key);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).toHashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        IndexField other = (IndexField)oth;
        if (this.key == null) {
            return this.key == other.key;
        }
        return this.key.equals(other.key);
    }

    public String toString() {
        return "[" + this.key.getName() + "]";
    }
}

