/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.jboss.windup.ast.java.BatchASTFuture;
import org.jboss.windup.ast.java.BatchASTListener;
import org.jboss.windup.ast.java.ReferenceResolvingVisitor;
import org.jboss.windup.ast.java.WildcardImportResolver;

public class BatchASTProcessor {
    private static final int BATCH_SIZE = 1000 / Runtime.getRuntime().availableProcessors();
    private static final int THREADPOOL_SIZE = Runtime.getRuntime().availableProcessors() / 2 + 1;

    public static BatchASTFuture analyze(final BatchASTListener listener, final WildcardImportResolver importResolver, final Set<String> libraryPaths, final Set<String> sourcePaths, Set<Path> sourceFiles) {
        final ExecutorService executor = Executors.newFixedThreadPool(THREADPOOL_SIZE);
        final String[] encodings = null;
        final String[] bindingKeys = new String[]{};
        final FileASTRequestor requestor = new FileASTRequestor(){

            public void acceptAST(String sourcePath, CompilationUnit ast) {
                try {
                    super.acceptAST(sourcePath, ast);
                    ReferenceResolvingVisitor visitor = new ReferenceResolvingVisitor(importResolver, ast, sourcePath);
                    ast.accept((ASTVisitor)visitor);
                    listener.processed(Paths.get(sourcePath, new String[0]), visitor.getJavaClassReferences());
                }
                catch (Throwable t) {
                    listener.failed(Paths.get(sourcePath, new String[0]), t);
                }
            }
        };
        List<List<String>> batches = BatchASTProcessor.createBatches(sourceFiles);
        for (final List<String> batch : batches) {
            executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ASTParser parser = ASTParser.newParser((int)8);
                    parser.setBindingsRecovery(false);
                    parser.setResolveBindings(true);
                    Hashtable options = JavaCore.getOptions();
                    JavaCore.setComplianceOptions((String)"1.8", (Map)options);
                    options.put("org.eclipse.jdt.core.incompleteClasspath", "warning");
                    options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
                    options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
                    options.put("org.eclipse.jdt.core.circularClasspath", "warning");
                    options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
                    options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
                    options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                    options.put("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", "warning");
                    options.put("org.eclipse.jdt.core.classpath.outputOverlappingAnotherSource", "warning");
                    parser.setCompilerOptions((Map)options);
                    parser.setCompilerOptions((Map)options);
                    parser.setEnvironment(libraryPaths.toArray(new String[libraryPaths.size()]), sourcePaths.toArray(new String[sourcePaths.size()]), null, true);
                    parser.createASTs(batch.toArray(new String[batch.size()]), encodings, bindingKeys, requestor, null);
                    return null;
                }
            });
        }
        executor.shutdown();
        return new BatchASTFuture(){

            @Override
            public boolean isDone() {
                return executor.isTerminated();
            }
        };
    }

    private static List<List<String>> createBatches(Set<Path> sourceFiles) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> batch = new ArrayList<String>(BATCH_SIZE);
        for (Path path : sourceFiles) {
            if (batch.size() == BATCH_SIZE) {
                result.add(batch);
                batch = new ArrayList(BATCH_SIZE);
            }
            batch.add(path.toAbsolutePath().toString());
        }
        return result;
    }
}

