/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.DefaultVersionRange;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.MultipleVersionRange;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.SingleVersionRange;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionException;
import org.jboss.forge.furnace.versions.VersionRange;

public class Versions {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static boolean isApiCompatible(Version runtimeVersion, Version addonApiVersion) {
        if (addonApiVersion == null || addonApiVersion.toString().length() == 0 || runtimeVersion == null || runtimeVersion.toString().length() == 0) {
            return true;
        }
        int runtimeMajorVersion = runtimeVersion.getMajorVersion();
        int runtimeMinorVersion = runtimeVersion.getMinorVersion();
        int addonApiMajorVersion = addonApiVersion.getMajorVersion();
        int addonApiMinorVersion = addonApiVersion.getMinorVersion();
        return addonApiMajorVersion == runtimeMajorVersion && addonApiMinorVersion <= runtimeMinorVersion;
    }

    public static VersionRange parseVersionRange(String range) throws VersionException {
        DefaultVersionRange result;
        Assert.notNull(range, "Version range must not be null.");
        boolean lowerBoundInclusive = range.startsWith("[");
        boolean upperBoundInclusive = range.endsWith("]");
        String process = range.substring(1, range.length() - 1).trim();
        int index = process.indexOf(",");
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new VersionException("Single version must be surrounded by []: " + range);
            }
            SingleVersion version = new SingleVersion(process);
            result = new DefaultVersionRange(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new VersionException("Range cannot have identical boundaries: " + range);
            }
            SingleVersion lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = new SingleVersion(lowerBound);
            }
            SingleVersion upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = new SingleVersion(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new VersionException("Range defies version ordering: " + range);
            }
            result = new DefaultVersionRange(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return result;
    }

    public static MultipleVersionRange parseMultipleVersionRange(String intersection) throws VersionException {
        Assert.notNull(intersection, "Version range must not be null.");
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String process = intersection;
        Version upperBound = null;
        Version lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(")");
            int index = index2 = process.indexOf("]");
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new VersionException("Unbounded range: " + intersection);
            }
            VersionRange range = Versions.parseVersionRange(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = range.getMin();
            }
            if (upperBound != null && (range.getMin() == null || range.getMin().compareTo(upperBound) < 0)) {
                throw new VersionException("Ranges overlap: " + intersection);
            }
            ranges.add(range);
            upperBound = range.getMax();
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (ranges.size() > 0) {
                throw new VersionException("Only fully-qualified sets allowed in multiple version range scenario: " + intersection);
            }
            if (process.contains(",")) {
                String[] split;
                for (String version : split = process.split(",")) {
                    if (version.startsWith("[") || version.startsWith("(")) {
                        ranges.add(Versions.parseVersionRange(version));
                        continue;
                    }
                    ranges.add(new SingleVersionRange(new SingleVersion(version)));
                }
            } else {
                ranges.add(new SingleVersionRange(new SingleVersion(process)));
            }
        }
        return new MultipleVersionRange(ranges);
    }

    public static VersionRange intersection(VersionRange ... ranges) {
        Assert.notNull(ranges, "Version ranges must not be null.");
        Assert.isTrue(ranges.length >= 1, "Version ranges must not be empty.");
        return Versions.intersection(Arrays.asList(ranges));
    }

    public static VersionRange intersection(Collection<VersionRange> ranges) {
        Assert.notNull(ranges, "Version ranges must not be null.");
        Assert.isTrue(ranges.size() >= 1, "Version ranges must not be empty.");
        Version min = null;
        Version max = null;
        boolean minInclusive = false;
        boolean maxInclusive = false;
        for (VersionRange range : ranges) {
            if (min == null || range.getMin().compareTo(min) > 0) {
                min = range.getMin();
                minInclusive = range.isMinInclusive();
            }
            if (max != null && range.getMax().compareTo(max) >= 0) continue;
            max = range.getMax();
            maxInclusive = range.isMaxInclusive();
        }
        return new DefaultVersionRange(min, minInclusive, max, maxInclusive);
    }

    public static boolean isSnapshot(Version version) {
        Assert.notNull(version, "Version must not be null.");
        return version.toString().endsWith(SNAPSHOT_SUFFIX);
    }

    public static Version getSpecificationVersionFor(Class<?> type) {
        String version;
        Assert.notNull(type, "Type must not be null.");
        Package pkg = type.getPackage();
        Version result = pkg == null ? EmptyVersion.getInstance() : (Strings.isNullOrEmpty(version = pkg.getSpecificationVersion()) ? EmptyVersion.getInstance() : new SingleVersion(version));
        return result;
    }

    public static Version getImplementationVersionFor(Class<?> type) {
        String version;
        Assert.notNull(type, "Type must not be null.");
        Package pkg = type.getPackage();
        Version result = pkg == null ? EmptyVersion.getInstance() : (Strings.isNullOrEmpty(version = pkg.getImplementationVersion()) ? EmptyVersion.getInstance() : new SingleVersion(version));
        return result;
    }
}

