/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.MergedIterator;

class CoalescedUpdates {
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Iterable<Term>> iterables = new ArrayList<Iterable<Term>>();
    final List<DocValuesUpdate.NumericDocValuesUpdate> numericDVUpdates = new ArrayList<DocValuesUpdate.NumericDocValuesUpdate>();
    final List<DocValuesUpdate.BinaryDocValuesUpdate> binaryDVUpdates = new ArrayList<DocValuesUpdate.BinaryDocValuesUpdate>();

    CoalescedUpdates() {
    }

    public String toString() {
        return "CoalescedUpdates(termSets=" + this.iterables.size() + ",queries=" + this.queries.size() + ",numericDVUpdates=" + this.numericDVUpdates.size() + ",binaryDVUpdates=" + this.binaryDVUpdates.size() + ")";
    }

    void update(FrozenBufferedUpdates in) {
        DocValuesUpdate clone;
        this.iterables.add(in.termsIterable());
        for (int queryIdx = 0; queryIdx < in.queries.length; ++queryIdx) {
            Query query = in.queries[queryIdx];
            this.queries.put(query, BufferedUpdates.MAX_INT);
        }
        for (DocValuesUpdate.NumericDocValuesUpdate numericDocValuesUpdate : in.numericDVUpdates) {
            clone = new DocValuesUpdate.NumericDocValuesUpdate(numericDocValuesUpdate.term, numericDocValuesUpdate.field, (Long)numericDocValuesUpdate.value);
            clone.docIDUpto = Integer.MAX_VALUE;
            this.numericDVUpdates.add((DocValuesUpdate.NumericDocValuesUpdate)clone);
        }
        for (DocValuesUpdate docValuesUpdate : in.binaryDVUpdates) {
            clone = new DocValuesUpdate.BinaryDocValuesUpdate(((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate).term, ((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate).field, (BytesRef)((DocValuesUpdate.BinaryDocValuesUpdate)docValuesUpdate).value);
            ((DocValuesUpdate.BinaryDocValuesUpdate)clone).docIDUpto = Integer.MAX_VALUE;
            this.binaryDVUpdates.add((DocValuesUpdate.BinaryDocValuesUpdate)clone);
        }
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                Iterator[] subs = new Iterator[CoalescedUpdates.this.iterables.size()];
                for (int i = 0; i < CoalescedUpdates.this.iterables.size(); ++i) {
                    subs[i] = CoalescedUpdates.this.iterables.get(i).iterator();
                }
                return new MergedIterator<Term>(subs);
            }
        };
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = CoalescedUpdates.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> ent = this.iter.next();
                        return new BufferedUpdatesStream.QueryAndLimit(ent.getKey(), ent.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

