/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Qualifier;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.cdi.services.ExportedInstanceImpl;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Addons;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class WeldServiceRegistry
implements ServiceRegistry {
    private final Class<?>[] serviceTypes;
    private final BeanManager manager;
    private final Addon addon;
    private final LockManager lock;
    private final Set<Class<?>> servicesSet;
    private final Map<String, ExportedInstance<?>> instanceCache = new WeakHashMap();
    private final Map<String, Set<ExportedInstance<?>>> instancesCache = new WeakHashMap();

    public WeldServiceRegistry(LockManager lock, Addon addon, BeanManager manager, Set<Class<?>> services) {
        this.lock = lock;
        this.addon = addon;
        this.manager = manager;
        LinkedHashSet copy = new LinkedHashSet();
        copy.addAll(services);
        this.serviceTypes = new ArrayList(copy).toArray(new Class[copy.size()]);
        this.servicesSet = Collections.unmodifiableSet(new LinkedHashSet(Arrays.asList(this.serviceTypes)));
    }

    public <T> ExportedInstance<T> getExportedInstance(String clazz) {
        try {
            return this.getExportedInstance(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> ExportedInstance<T> getExportedInstance(final Class<T> clazz) {
        Assert.notNull(clazz, (String)"Requested Class type may not be null");
        Addons.waitUntilStarted((Addon)this.addon);
        ExportedInstance result = this.instanceCache.get(clazz.getName());
        if (result == null) {
            try {
                result = (ExportedInstance)ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)new Callable<ExportedInstance<T>>(){

                    @Override
                    public ExportedInstance<T> call() throws Exception {
                        Set beans = WeldServiceRegistry.this.manager.getBeans((Type)clazz, WeldServiceRegistry.getQualifiersFrom(clazz));
                        if (!beans.isEmpty()) {
                            ExportedInstanceImpl result = new ExportedInstanceImpl(WeldServiceRegistry.this.addon, WeldServiceRegistry.this.manager, WeldServiceRegistry.this.manager.resolve(beans), clazz, clazz);
                            WeldServiceRegistry.this.instanceCache.put(clazz.getName(), result);
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new ContainerException("Could not get service of type [" + clazz + "] from addon [" + this.addon + "]", (Throwable)e);
            }
        }
        return result;
    }

    public boolean hasService(String clazz) {
        try {
            return this.hasService(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean hasService(Class<?> clazz) {
        Addons.waitUntilStarted((Addon)this.addon);
        for (Class<?> service : this.serviceTypes) {
            if (!clazz.isAssignableFrom(service)) continue;
            return true;
        }
        return false;
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(String clazz) {
        try {
            return this.getExportedInstances(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return Collections.emptySet();
        }
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(final Class<T> clazz) {
        Addons.waitUntilStarted((Addon)this.addon);
        Set<ExportedInstance<T>> result = this.instancesCache.get(clazz.getName());
        if (result == null || result.isEmpty()) {
            result = new HashSet();
            for (int i = 0; i < this.serviceTypes.length; ++i) {
                final Class<?> type = this.serviceTypes[i];
                if (clazz.isAssignableFrom(type)) {
                    try {
                        result.addAll((Collection)ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)new Callable<Set<ExportedInstance<T>>>(){

                            @Override
                            public Set<ExportedInstance<T>> call() throws Exception {
                                HashSet result = new HashSet();
                                Set beans = WeldServiceRegistry.this.manager.getBeans((Type)type, WeldServiceRegistry.getQualifiersFrom(type));
                                Class assignableClass = type;
                                for (Bean bean : beans) {
                                    result.add(new ExportedInstanceImpl(WeldServiceRegistry.this.addon, WeldServiceRegistry.this.manager, bean, clazz, assignableClass));
                                }
                                return result;
                            }
                        }));
                    }
                    catch (Exception e) {
                        throw new ContainerException("Could not get services of type [" + clazz + "] from addon [" + this.addon + "]", (Throwable)e);
                    }
                }
                this.instancesCache.put(clazz.getName(), result);
            }
        }
        return result;
    }

    public Set<Class<?>> getExportedTypes() {
        return this.servicesSet;
    }

    public <T> Set<Class<T>> getExportedTypes(Class<T> type) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class<?> serviceType : this.serviceTypes) {
            if (!type.isAssignableFrom(serviceType)) continue;
            result.add(serviceType);
        }
        return result;
    }

    public String toString() {
        return this.serviceTypes.toString();
    }

    public static Annotation[] getQualifiersFrom(Class<?> c) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        for (Annotation annotation : c.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            annotations.add(annotation);
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }
}

