/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.model;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.Logging;
import org.w3c.dom.Document;

public class XMLDocumentCache {
    private static final Logger LOG = Logging.get(XMLDocumentCache.class);
    private static final Map<String, CacheDocument> map = new HashMap<String, CacheDocument>();

    public static void cache(XmlFileModel key, Document document) {
        String cacheKey = XMLDocumentCache.getKey(key);
        map.put(cacheKey, new CacheDocument(false, document));
    }

    public static void cacheParseFailure(XmlFileModel key) {
        map.put(XMLDocumentCache.getKey(key), new CacheDocument(true, null));
    }

    public static Result get(XmlFileModel key) {
        String cacheKey = XMLDocumentCache.getKey(key);
        Object result = null;
        CacheDocument reference = map.get(cacheKey);
        if (reference == null) {
            return new Result(false, null);
        }
        if (reference.parseFailure) {
            return new Result(true, null);
        }
        Document document = reference.getDocument();
        if (document == null) {
            LOG.info("Cache miss on XML document: " + cacheKey);
        }
        return new Result(false, document);
    }

    private static String getKey(XmlFileModel key) {
        return key.getFilePath();
    }

    private static class CacheDocument {
        private boolean parseFailure;
        private SoftReference<Document> document;

        public CacheDocument(boolean parseFailure, Document document) {
            this.parseFailure = parseFailure;
            this.document = new SoftReference<Document>(document);
        }

        public Document getDocument() {
            return this.document.get();
        }
    }

    public static class Result {
        private boolean parseFailure;
        private Document document;

        public Result(boolean parseFailure, Document document) {
            this.parseFailure = parseFailure;
            this.document = document;
        }

        public boolean isParseFailure() {
            return this.parseFailure;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

