/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.xml.model.XMLDocumentCache;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlFileService
extends GraphService<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(XmlFileService.class.getSimpleName());

    public XmlFileService(GraphContext ctx) {
        super(ctx, XmlFileModel.class);
    }

    public Document loadDocumentQuiet(XmlFileModel model) {
        Document document;
        ClassificationService classificationService = new ClassificationService(this.getGraphContext());
        if (model.asFile().length() == 0L) {
            LOG.log(Level.WARNING, "Failed to parse xml entity: " + model.getFilePath() + ", as the file is empty.");
            return null;
        }
        XMLDocumentCache.Result cacheResult = XMLDocumentCache.get(model);
        if (cacheResult.isParseFailure()) {
            LOG.log(Level.FINE, "Not loading entity: " + model.getFilePath() + ", due to previous parse failures");
            document = null;
        } else if (cacheResult.getDocument() == null) {
            try (InputStream is = model.asInputStream();){
                document = LocationAwareXmlReader.readXML((InputStream)is);
                XMLDocumentCache.cache(model, document);
            }
            catch (SAXException e) {
                XMLDocumentCache.cacheParseFailure(model);
                document = null;
                LOG.log(Level.WARNING, "Failed to parse xml entity: " + model.getFilePath() + ", due to: " + e.getMessage());
                classificationService.attachClassification((FileModel)model, "Unparseable XML File", "This file could not be parsed");
            }
            catch (IOException e) {
                XMLDocumentCache.cacheParseFailure(model);
                document = null;
                LOG.log(Level.WARNING, "Failed to parse xml entity: " + model.getFilePath() + ", due to: " + e.getMessage());
                classificationService.attachClassification((FileModel)model, "Unparseable XML File", "This file could not be parsed");
            }
        } else {
            document = cacheResult.getDocument();
        }
        return document;
    }
}

