/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class PathUtil {
    private static final Logger LOG = Logger.getLogger(PathUtil.class.getName());
    public static final String WINDUP_HOME = "windup.home";
    public static final String RULES_DIRECTORY_NAME = "rules";
    public static final String IGNORE_DIRECTORY_NAME = "ignore";
    public static final String CACHE_DIRECTORY_NAME = "cache";
    public static final String ADDONS_DIRECTORY_NAME = "addons";
    public static String LIBRARY_DIRECTORY_NAME = "lib";
    public static String BINARY_DIRECTORY_NAME = "bin";

    public static Path getWindupUserDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            Path path = new File("").toPath();
            LOG.warning("$USER_HOME not set, using [" + path + "] instead.");
            return path;
        }
        return Paths.get(userHome, new String[0]).resolve(".windup");
    }

    public static Path getWindupHome() {
        String windupHome = System.getProperty(WINDUP_HOME);
        if (windupHome == null) {
            Path path = new File("").toPath();
            LOG.warning("$WINDUP_HOME not set, using [" + path + "] instead.");
            return path;
        }
        return Paths.get(windupHome, new String[0]);
    }

    public static void setWindupHome(Path windupHome) {
        System.setProperty(WINDUP_HOME, windupHome.toAbsolutePath().toString());
    }

    public static Path getUserCacheDir() {
        return PathUtil.getUserSubdirectory(CACHE_DIRECTORY_NAME);
    }

    public static Path getWindupCacheDir() {
        return PathUtil.getWindupSubdirectory(CACHE_DIRECTORY_NAME);
    }

    public static Path getUserIgnoreDir() {
        return PathUtil.getUserSubdirectory(IGNORE_DIRECTORY_NAME);
    }

    public static Path getWindupIgnoreDir() {
        return PathUtil.getWindupSubdirectory(IGNORE_DIRECTORY_NAME);
    }

    public static Path getWindupAddonsDir() {
        return PathUtil.getWindupSubdirectory(ADDONS_DIRECTORY_NAME);
    }

    public static Path getUserRulesDir() {
        return PathUtil.getUserSubdirectory(RULES_DIRECTORY_NAME);
    }

    public static Path getWindupRulesDir() {
        return PathUtil.getWindupSubdirectory(RULES_DIRECTORY_NAME);
    }

    public static String cleanFileName(String badFileName) {
        if (badFileName == null) {
            return null;
        }
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    public static String classFilePathToClassname(String classFilePath) {
        if (classFilePath == null) {
            return null;
        }
        int pos = classFilePath.lastIndexOf(".class");
        if (pos < 0) {
            throw new IllegalArgumentException("Not a .class file path: " + classFilePath);
        }
        return classFilePath.substring(0, pos).replace('/', '.').replace('\\', '.');
    }

    public static Path getRootFolderForSource(Path sourceFilePath, String packageName) {
        if (packageName == null || packageName.trim().equals("")) {
            return sourceFilePath.getParent();
        }
        String[] packageNameComponents = packageName.split("\\.");
        Path currentPath = sourceFilePath.getParent();
        for (int i = packageNameComponents.length; i > 0; --i) {
            String packageComponent = packageNameComponents[i - 1];
            if (!StringUtils.equals((CharSequence)packageComponent, (CharSequence)currentPath.getFileName().toString())) {
                return null;
            }
            currentPath = currentPath.getParent();
        }
        return currentPath;
    }

    private static Path getUserSubdirectory(String subdirectory) {
        Path windupUserDir = PathUtil.getWindupUserDir();
        if (windupUserDir == null) {
            return null;
        }
        return windupUserDir.resolve(subdirectory);
    }

    private static Path getWindupSubdirectory(String subdirectory) {
        Path windupHome = PathUtil.getWindupHome();
        if (windupHome == null) {
            return null;
        }
        return windupHome.resolve(subdirectory);
    }
}

