/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLocationReport
extends AbstractReport {
    private static final String NAME = "Class Location";
    private static final String DIRECTORY = "classlocation";
    private SortedMap<String, SortedSet<String>> gProvides;

    public ClassLocationReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    public void setGlobalProvides(SortedMap<String, SortedSet<String>> gProvides) {
        this.gProvides = gProvides;
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Class</th>" + Dump.newLine());
        bw.write("     <th>Jar files</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        for (Map.Entry<String, SortedSet<String>> entry : this.gProvides.entrySet()) {
            String clz = entry.getKey();
            SortedSet<String> archives = entry.getValue();
            boolean filtered = this.isFiltered(clz);
            if (!filtered && archives.size() > 1) {
                this.status = 1;
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td>" + clz + "</td>" + Dump.newLine());
            if (!filtered) {
                bw.write("        <td>");
            } else {
                bw.write("        <td style=\"text-decoration: line-through;\">");
            }
            Iterator sit = archives.iterator();
            while (sit.hasNext()) {
                String archive = (String)sit.next();
                int finalDot = archive.lastIndexOf(".");
                String extension = archive.substring(finalDot + 1);
                bw.write("<a href=\"../" + extension + "/" + archive + ".html\">" + archive + "</a>" + Dump.newLine());
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Class Location</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

