/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.SizeComparator;

public class KeyFilter
implements Filter {
    private SortedSet<String> keyFilters = new TreeSet<String>(new SizeComparator());

    public boolean isFiltered() {
        throw new UnsupportedOperationException("isFiltered() not supported");
    }

    public boolean isFiltered(String archive) {
        if (archive.endsWith(".class")) {
            archive = archive.substring(0, archive.indexOf(".class"));
        }
        if (archive.endsWith(".jar")) {
            archive = archive.substring(0, archive.indexOf(".jar"));
        }
        if (archive.endsWith(".*")) {
            archive = archive.substring(0, archive.indexOf(".*"));
        }
        archive = archive.replace('.', '/');
        for (String v : this.keyFilters) {
            if (!archive.startsWith(v)) continue;
            return true;
        }
        return false;
    }

    public boolean isFiltered(String archive, String query) {
        throw new UnsupportedOperationException("isFiltered(String, String) not supported");
    }

    public void init(String filter) {
        if (filter != null) {
            StringTokenizer vt = new StringTokenizer(filter, ",");
            while (vt.hasMoreTokens()) {
                String value = vt.nextToken();
                boolean includeAll = false;
                if (value.endsWith(".class")) {
                    value = value.substring(0, value.indexOf(".class"));
                }
                if (value.endsWith(".jar")) {
                    value = value.substring(0, value.indexOf(".jar"));
                }
                if (value.endsWith(".*")) {
                    value = value.substring(0, value.indexOf(".*"));
                    includeAll = true;
                }
                value = value.replace('.', '/');
                if (includeAll) {
                    value = value + '/';
                }
                this.keyFilters.add(value);
            }
        }
    }
}

