/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

public class UnusedJarReport
extends AbstractReport {
    private static final String NAME = "Unused Jar";
    private static final String DIRECTORY = "unusedjar";

    public UnusedJarReport() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Used</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        int used = 0;
        int unused = 0;
        for (Archive archive : this.archives) {
            boolean archiveStatus = false;
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            Iterator it = this.archives.iterator();
            while (!archiveStatus && it.hasNext()) {
                Archive a = (Archive)it.next();
                if (archive.getName().equals(a.getName())) continue;
                Iterator sit = a.getRequires().iterator();
                while (!archiveStatus && sit.hasNext()) {
                    String require = (String)sit.next();
                    if (!archive.getProvides().keySet().contains(require)) continue;
                    archiveStatus = true;
                }
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            if (archiveStatus) {
                bw.write("     <td style=\"color: green;\">Yes</td>" + Dump.newLine());
                ++used;
            } else {
                ++unused;
                if (!this.isFiltered(archive.getName())) {
                    this.status = 1;
                    bw.write("     <td style=\"color: red;\">No</td>" + Dump.newLine());
                } else {
                    bw.write("     <td style=\"color: red; text-decoration: line-through;\">No</td>" + Dump.newLine());
                }
            }
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<p>" + Dump.newLine());
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("     <th>Archives</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Used</td>" + Dump.newLine());
        bw.write("     <td style=\"color: green;\">" + used + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Unused</td>" + Dump.newLine());
        bw.write("     <td style=\"color: red;\">" + unused + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Unused Jar</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    protected Filter createFilter() {
        return new KeyFilter();
    }
}

