/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;

public class EffortPointsToCssClass
implements WindupFreeMarkerMethod {
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (int)");
        }
        SimpleNumber freemarkerArg = (SimpleNumber)arguments.get(0);
        int effortPoints = freemarkerArg.getAsNumber().intValue();
        if (effortPoints == 0) {
            return "info";
        }
        if (effortPoints < 8) {
            return "warning";
        }
        if (effortPoints < 14) {
            return "severe";
        }
        return "critical";
    }

    public String getMethodName() {
        return "effortPointsToCssClass";
    }

    public String getDescription() {
        return "Converts from effort points to a CSS class";
    }

    public void setContext(GraphRewrite event) {
    }
}

