/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.reporting.config.HintText;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="hint", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class HintHandler
implements ElementHandler<Hint> {
    public Hint processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String title = JOOX.$((Element)element).attr("title");
        String severityStr = JOOX.$((Element)element).attr("severity");
        String message = JOOX.$((Element)element).attr("message");
        String in = JOOX.$((Element)element).attr("in");
        if (StringUtils.isBlank((String)message)) {
            StringBuilder messageBuilder = new StringBuilder();
            List children = JOOX.$((Element)element).children().get();
            for (Element child : children) {
                if (!child.getNodeName().equals("message")) continue;
                messageBuilder.append(handlerManager.processElement(child));
            }
            message = messageBuilder.toString();
            message = this.trimLeadingAndTrailingSpaces(message);
        }
        if (StringUtils.isBlank((String)message)) {
            throw new WindupException("Error, 'hint' element must have a non-empty 'message' attribute or element");
        }
        String effortStr = JOOX.$((Element)element).attr("effort");
        HintText hint = !StringUtils.isBlank((String)title) ? Hint.in((String)in).titled(title).withText(message) : Hint.in((String)in).withText(message);
        if (StringUtils.isNotBlank((String)severityStr)) {
            Severity severity = Severity.valueOf((String)severityStr.toUpperCase());
            hint.withSeverity(severity);
        }
        if (!StringUtils.isBlank((String)effortStr)) {
            try {
                int effort = Integer.parseInt(effortStr);
                hint.withEffort(effort);
            }
            catch (NumberFormatException e) {
                throw new WindupException("Could not parse effort level: " + effortStr + " as an integer!");
            }
        }
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            if (!child.getNodeName().equals("link")) continue;
            Link link = (Link)handlerManager.processElement(child);
            hint.with(link);
        }
        return (Hint)hint;
    }

    private String trimLeadingAndTrailingSpaces(String markdown) {
        StringBuilder markdownSB = new StringBuilder();
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < markdown.length(); ++i) {
            char currentChar = markdown.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                markdownSB.append(currentLine.toString().trim()).append(SystemUtils.LINE_SEPARATOR);
                currentLine.setLength(0);
                if (currentChar != '\r' || markdown.length() <= i + 1 || markdown.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            currentLine.append(currentChar);
        }
        markdownSB.append((CharSequence)currentLine);
        return markdownSB.toString();
    }
}

