/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.ast.ASTNamespaceDecl;
import org.openrdf.query.parser.serql.ast.ASTQName;
import org.openrdf.query.parser.serql.ast.ASTQueryContainer;
import org.openrdf.query.parser.serql.ast.ASTURI;
import org.openrdf.query.parser.serql.ast.VisitorException;

class NamespaceDeclProcessor
extends ASTVisitorBase {
    NamespaceDeclProcessor() {
    }

    public static Map<String, String> process(ASTQueryContainer qc) throws MalformedQueryException {
        HashMap<String, String> extendedNsMap;
        List<ASTNamespaceDecl> nsDeclList = qc.getNamespaceDeclList();
        LinkedHashMap<String, String> nsMap = new LinkedHashMap<String, String>();
        for (ASTNamespaceDecl nsDecl : nsDeclList) {
            String prefix = nsDecl.getPrefix();
            String uri = nsDecl.getURI().getValue();
            if (nsMap.containsKey(prefix)) {
                if (((String)nsMap.get(prefix)).equals(uri)) continue;
                throw new MalformedQueryException("Multiple namespace declarations for prefix '" + prefix + "'");
            }
            nsMap.put(prefix, uri);
        }
        if (!nsMap.containsKey("rdf")) {
            nsMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        }
        if (!nsMap.containsKey("rdfs")) {
            nsMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        }
        if (!nsMap.containsKey("xsd")) {
            nsMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
        if (!nsMap.containsKey("owl")) {
            nsMap.put("owl", "http://www.w3.org/2002/07/owl#");
        }
        if (!nsMap.containsKey("sesame")) {
            nsMap.put("sesame", "http://www.openrdf.org/schema/sesame#");
        }
        if (!(extendedNsMap = new HashMap<String, String>(nsMap)).containsKey("serql")) {
            extendedNsMap.put("serql", "http://www.openrdf.org/schema/sesame#");
        }
        QNameProcessor visitor = new QNameProcessor(extendedNsMap);
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        return nsMap;
    }

    private static class QNameProcessor
    extends ASTVisitorBase {
        private Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            ASTURI uriNode = new ASTURI(60);
            uriNode.setValue(namespace + localName);
            qnameNode.jjtReplaceWith(uriNode);
            return null;
        }
    }
}

