/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.fernflower;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.windup.decompiler.api.ClassDecompileRequest;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.fernflower.FernFlowerResultSaver;
import org.jboss.windup.decompiler.fernflower.FernflowerJDKLogger;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.Checks;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FernflowerDecompiler
implements Decompiler {
    private static final Logger LOG = Logger.getLogger(FernflowerDecompiler.class.getName());
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int numberOfThreads = 1;

    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
    }

    public void setExecutorService(ExecutorService service, int numberOfThreads) {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
        this.numberOfThreads = numberOfThreads;
        this.executorService = service;
    }

    private Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("mpm", 30);
        return options;
    }

    private IBytecodeProvider getByteCodeProvider() {
        return new IBytecodeProvider(){

            public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                return InterpreterUtil.getBytes((File)new File(externalPath));
            }
        };
    }

    private IResultSaver getResultSaver(String classFile, File outputDirectory, DecompilationListener listener) {
        return new FernFlowerResultSaver(classFile, outputDirectory, listener);
    }

    public void decompileClassFiles(Collection<ClassDecompileRequest> allRequests, final DecompilationListener listener) {
        String key;
        HashMap<String, ArrayList<ClassDecompileRequest>> requestMap = new HashMap<String, ArrayList<ClassDecompileRequest>>();
        for (ClassDecompileRequest request : allRequests) {
            String filename = request.getClassFile().getFileName().toString();
            key = filename.matches(".*\\$.*.class") ? request.getClassFile().getParent().resolve(filename.substring(0, filename.indexOf("$")) + ".class").toString() : request.getClassFile().toString();
            ArrayList<ClassDecompileRequest> list = (ArrayList<ClassDecompileRequest>)requestMap.get(key);
            if (list == null) {
                list = new ArrayList<ClassDecompileRequest>();
                requestMap.put(key, list);
            }
            list.add(request);
        }
        ArrayList<2> tasks = new ArrayList<2>(requestMap.size());
        for (Map.Entry entry : requestMap.entrySet()) {
            key = (String)entry.getKey();
            final List requests = (List)entry.getValue();
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClassDecompileRequest firstRequest = (ClassDecompileRequest)requests.get(0);
                    IResultSaver resultSaver = FernflowerDecompiler.this.getResultSaver(firstRequest.getClassFile().toString(), firstRequest.getOutputDirectory().toFile(), listener);
                    Fernflower fernflower = new Fernflower(FernflowerDecompiler.this.getByteCodeProvider(), resultSaver, FernflowerDecompiler.this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
                    for (ClassDecompileRequest request : requests) {
                        fernflower.getStructContext().addSpace(request.getClassFile().toFile(), true);
                    }
                    try {
                        fernflower.decompileContext();
                    }
                    catch (Throwable t) {
                        listener.decompilationFailed(key, "Decompilation failed due to: " + t.getMessage());
                        LOG.warning("Decompilation of " + key + " failed due to: " + t.getMessage());
                    }
                    return null;
                }
            };
            tasks.add(task);
        }
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Decompilation was interrupted.");
        }
        finally {
            listener.decompilationProcessComplete();
        }
    }

    public DecompilationResult decompileClassFile(Path rootDir, Path classFilePath, Path outputDir) throws DecompilationException {
        final DecompilationResult result = new DecompilationResult();
        DecompilationListener listener = new DecompilationListener(){

            public void fileDecompiled(String inputPath, String outputPath) {
                result.addDecompiled(inputPath, outputPath);
            }

            public void decompilationFailed(String inputPath, String message) {
                result.addFailure(new DecompilationFailure(message, inputPath, null));
            }

            public void decompilationProcessComplete() {
            }
        };
        IResultSaver resultSaver = this.getResultSaver(classFilePath.toString(), outputDir.toFile(), listener);
        Fernflower fernflower = new Fernflower(this.getByteCodeProvider(), resultSaver, this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
        fernflower.getStructContext().addSpace(classFilePath.toFile(), true);
        fernflower.decompileContext();
        return result;
    }

    public DecompilationResult decompileArchive(Path archive, Path outputDir, DecompilationListener listener) throws DecompilationException {
        return this.decompileArchive(archive, outputDir, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecompilationResult decompileArchive(Path archive, Path outputDir, Filter<ZipEntry> filter, final DecompilationListener delegate) throws DecompilationException {
        JarFile jar;
        Checks.checkFileToBeRead((File)archive.toFile(), (String)"Archive to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir.toFile(), (String)"Output directory");
        final DecompilationResult result = new DecompilationResult();
        DecompilationListener listener = new DecompilationListener(){

            public void fileDecompiled(String inputPath, String outputPath) {
                result.addDecompiled(inputPath, outputPath);
                delegate.fileDecompiled(inputPath, outputPath);
            }

            public void decompilationFailed(String inputPath, String message) {
                result.addFailure(new DecompilationFailure(message, inputPath, null));
                delegate.decompilationFailed(inputPath, message);
            }

            public void decompilationProcessComplete() {
                delegate.decompilationProcessComplete();
            }
        };
        LOG.info("Decompiling archive '" + archive.toAbsolutePath() + "' to '" + outputDir.toAbsolutePath() + "'");
        try {
            jar = new JarFile(archive.toFile());
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + archive, (Throwable)ex);
        }
        try {
            AtomicInteger jarEntryCount = new AtomicInteger(0);
            Enumeration<JarEntry> countEnum = jar.entries();
            while (countEnum.hasMoreElements()) {
                countEnum.nextElement();
                jarEntryCount.incrementAndGet();
            }
            AtomicInteger current = new AtomicInteger(0);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                final JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                if (entry.getName().contains("$")) continue;
                if (filter != null) {
                    Filter.Result filterRes = filter.decide((Object)entry);
                    if (filterRes == Filter.Result.REJECT) {
                        jarEntryCount.decrementAndGet();
                        continue;
                    }
                    if (filterRes == Filter.Result.STOP) break;
                }
                IBytecodeProvider bytecodeProvider = new IBytecodeProvider(){

                    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                        return InterpreterUtil.getBytes((ZipFile)jar, (ZipEntry)entry);
                    }
                };
                IResultSaver resultSaver = this.getResultSaver(entry.getName(), outputDir.toFile(), listener);
                Fernflower fernflower = new Fernflower(bytecodeProvider, resultSaver, this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
                fernflower.getStructContext().addSpace(new File(entry.getName()), true);
                fernflower.decompileContext();
            }
            listener.decompilationProcessComplete();
            DecompilationResult decompilationResult = result;
            return decompilationResult;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                LOG.warning("Failed to close jar file: " + jar.getName());
            }
        }
    }
}

