/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.impl;

import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.ClassLoaderInterceptor;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.spi.ExportedInstance;

public class SimpleSingletonExportedInstanceImpl<T>
implements ExportedInstance<T> {
    private final Addon addon;
    private final Class<T> type;
    private T delegate = null;

    public SimpleSingletonExportedInstanceImpl(Furnace furnace, Addon addon, Class<T> clazz) {
        this.addon = addon;
        this.type = clazz;
    }

    public T get() {
        if (this.delegate == null) {
            try {
                this.delegate = this.type.newInstance();
                this.delegate = Proxies.enhance((ClassLoader)this.addon.getClassLoader(), this.delegate, (ForgeProxy)new ClassLoaderInterceptor(this.addon.getClassLoader(), this.delegate));
            }
            catch (Exception e) {
                throw new ContainerException("Could not create instance of [" + this.type.getName() + "] through reflection.", (Throwable)e);
            }
        }
        return this.delegate;
    }

    public void release(T instance) {
        if (instance == this.delegate) {
            this.delegate = null;
        }
    }

    public String toString() {
        return "Singleton: " + this.type.getName() + " from " + this.addon;
    }

    public Class<? extends T> getActualType() {
        return this.type;
    }

    public Addon getSourceAddon() {
        return this.addon;
    }
}

