/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

class DiskOrderedScanner {
    private static final LogEntryType[] LN_ONLY = new LogEntryType[]{LogEntryType.LOG_INS_LN};
    private static final LogEntryType[] BIN_ONLY = new LogEntryType[]{LogEntryType.LOG_BIN};
    private static final LogEntryType[] BIN_OR_DELTA = new LogEntryType[]{LogEntryType.LOG_BIN_DELTA, LogEntryType.LOG_BIN};
    private final DatabaseImpl dbImpl;
    private final RecordProcessor processor;
    private final boolean keysOnly;
    private final long lsnBatchSize;
    private final long memoryLimit;
    private final boolean dupDb;
    private final boolean binsOnly;
    private final Map<Long, DbFileSummary> dbFileSummaries;
    private final LSNAccumulator lsnAcc;
    private long memoryUsage;
    private byte[] prevEndingKey;
    private byte[] newEndingKey;
    private volatile int nIterations;

    DiskOrderedScanner(DatabaseImpl dbImpl, RecordProcessor processor, boolean keysOnly, long lsnBatchSize, long memoryLimit) {
        this.dbImpl = dbImpl;
        this.processor = processor;
        this.keysOnly = keysOnly;
        this.lsnBatchSize = lsnBatchSize;
        this.memoryLimit = memoryLimit;
        this.dupDb = dbImpl.getSortedDuplicates();
        this.binsOnly = this.dupDb || keysOnly;
        this.dbFileSummaries = dbImpl.cloneDbFileSummaries();
        this.lsnAcc = new LSNAccumulator(){

            void noteMemUsage(long increment) {
                DiskOrderedScanner.this.addMemoryUsage(increment);
            }
        };
    }

    private void addMemoryUsage(long increment) {
        this.memoryUsage += increment;
    }

    int getNIterations() {
        return this.nIterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        while (true) {
            Object var4_3;
            IN in = this.getFirstIN();
            try {
                while (in != null) {
                    if (this.binsOnly) {
                        this.accumulateBINs(in);
                    } else {
                        this.accumulateLNs(in);
                    }
                    if (this.accLimitExceeded()) break;
                    IN prevIn = in;
                    in = null;
                    in = this.getNextIN(prevIn);
                }
                var4_3 = null;
                if (in != null) {
                    in.releaseLatch();
                }
            }
            catch (Throwable throwable) {
                var4_3 = null;
                if (in != null) {
                    in.releaseLatch();
                }
                throw throwable;
            }
            long[] lsnArray = this.lsnAcc.getAndSortPendingLSNs();
            if (this.binsOnly) {
                this.fetchAndProcessBINs(lsnArray);
            } else {
                this.fetchAndProcessLNs(lsnArray);
            }
            ++this.nIterations;
            if (in == null) break;
            this.lsnAcc.clear();
            this.memoryUsage = 0L;
            this.prevEndingKey = this.newEndingKey;
        }
    }

    private boolean accLimitExceeded() {
        return this.memoryUsage >= this.memoryLimit || (long)this.lsnAcc.getNTotalEntries() > this.lsnBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void accumulateBINs(IN parent) {
        int i = 0;
        while (true) {
            block11: {
                if (i >= parent.getNEntries()) {
                    return;
                }
                if (i + 1 >= parent.getNEntries() || this.prevEndingKey == null || Key.compareKeys(this.prevEndingKey, parent.getKey(i + 1), this.dbImpl.getKeyComparator()) < 0) {
                    Object var8_6;
                    BIN bin;
                    block13: {
                        block12: {
                            if (this.accLimitExceeded()) {
                                return;
                            }
                            long binLsn = parent.getLsn(i);
                            bin = (BIN)parent.getTarget(i);
                            if (bin != null) {
                                bin.latch();
                            }
                            try {
                                if (bin == null || !bin.getDirty() || !this.processor.canProcessWithoutBlocking(bin.getNEntries())) {
                                    this.lsnAcc.add(binLsn);
                                    this.addMemoryUsage(this.getDeltaMemSize(DbLsn.getFileNumber(binLsn)));
                                    var8_6 = null;
                                    if (bin == null) break block11;
                                    break block12;
                                }
                                for (int j = 0; j < bin.getNEntries(); ++j) {
                                    if (this.skipSlot(bin, j)) continue;
                                    this.processRecord(bin.getKey(j), null);
                                }
                                break block13;
                            }
                            catch (Throwable throwable) {
                                var8_6 = null;
                                if (bin != null) {
                                    bin.releaseLatch();
                                }
                                throw throwable;
                            }
                        }
                        bin.releaseLatch();
                        break block11;
                    }
                    var8_6 = null;
                    if (bin != null) {
                        bin.releaseLatch();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateLNs(IN parent) {
        for (int i = 0; i < parent.getNEntries(); ++i) {
            Object var7_7;
            if (i + 1 < parent.getNEntries() && this.prevEndingKey != null && Key.compareKeys(this.prevEndingKey, parent.getKey(i + 1), this.dbImpl.getKeyComparator()) >= 0) continue;
            if (this.accLimitExceeded()) {
                return;
            }
            BIN bin = (BIN)parent.getTarget(i);
            if (bin == null) {
                Object item = this.fetchItem(parent.getLsn(i), BIN_OR_DELTA);
                if (item instanceof BIN) {
                    bin = (BIN)item;
                } else {
                    BINDelta delta = (BINDelta)item;
                    bin = (BIN)this.fetchItem(delta.getLastFullLsn(), BIN_ONLY);
                    delta.reconstituteBIN(this.dbImpl, bin);
                }
            }
            bin.latch();
            try {
                for (int j = 0; j < bin.getNEntries(); ++j) {
                    if (this.skipSlot(bin, j)) continue;
                    LN ln = (LN)bin.getTarget(j);
                    if (ln == null || this.dbImpl.isDeferredWriteMode() && !ln.isDirty() || !this.processor.canProcessWithoutBlocking(1)) {
                        this.lsnAcc.add(bin.getLsn(j));
                        continue;
                    }
                    this.processRecord(bin.getKey(j), ln.getData());
                }
                var7_7 = null;
            }
            catch (Throwable throwable) {
                var7_7 = null;
                bin.releaseLatch();
                throw throwable;
            }
            bin.releaseLatch();
            {
                continue;
            }
        }
    }

    private void fetchAndProcessBINs(long[] lsnArray) {
        int i;
        BINDelta[] deltaArray = new BINDelta[lsnArray.length];
        int nDeltas = 0;
        for (i = 0; i < lsnArray.length; ++i) {
            Object item = this.fetchItem(lsnArray[i], BIN_OR_DELTA);
            if (item instanceof BINDelta) {
                BINDelta delta;
                deltaArray[nDeltas] = delta = (BINDelta)item;
                ++nDeltas;
                continue;
            }
            this.processBIN((BIN)item);
        }
        if (nDeltas == 0) {
            return;
        }
        Arrays.sort(deltaArray, 0, nDeltas, new Comparator<BINDelta>(){

            @Override
            public int compare(BINDelta a, BINDelta b) {
                return DbLsn.compareTo(a.getLastFullLsn(), b.getLastFullLsn());
            }
        });
        for (i = 0; i < nDeltas; ++i) {
            BINDelta delta = deltaArray[i];
            BIN bin = (BIN)this.fetchItem(delta.getLastFullLsn(), BIN_ONLY);
            delta.reconstituteBIN(this.dbImpl, bin);
            this.processBIN(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBIN(BIN bin) {
        bin.latch();
        try {
            for (int i = 0; i < bin.getNEntries(); ++i) {
                if (this.skipSlot(bin, i)) continue;
                this.processRecord(bin.getKey(i), null);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            bin.releaseLatch();
            throw throwable;
        }
        bin.releaseLatch();
    }

    private void fetchAndProcessLNs(long[] lsnArray) {
        for (int i = 0; i < lsnArray.length; ++i) {
            LNLogEntry entry = (LNLogEntry)this.fetchEntry(lsnArray[i], LN_ONLY);
            entry.postFetchInit(this.dbImpl);
            LN ln = entry.getMainItem();
            if (ln.isDeleted()) continue;
            this.processRecord(entry.getKey(), ln.getData());
        }
    }

    private void processRecord(byte[] treeKey, byte[] treeData) {
        byte[] data;
        byte[] key;
        if (this.dupDb) {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = this.keysOnly ? null : new DatabaseEntry();
            DupKeyData.split(treeKey, treeKey.length, keyEntry, dataEntry);
            key = keyEntry.getData();
            data = this.keysOnly ? null : dataEntry.getData();
        } else {
            key = treeKey;
            data = this.keysOnly ? null : treeData;
        }
        this.processor.process(key, data);
        if (this.newEndingKey == null || Key.compareKeys(this.newEndingKey, treeKey, this.dbImpl.getKeyComparator()) < 0) {
            this.newEndingKey = treeKey;
        }
    }

    private Object fetchItem(long lsn, LogEntryType[] expectTypes) {
        return this.fetchEntry(lsn, expectTypes).getMainItem();
    }

    private LogEntry fetchEntry(long lsn, LogEntryType[] expectTypes) {
        LogManager logManager = this.dbImpl.getDbEnvironment().getLogManager();
        LogEntry entry = logManager.getLogEntryHandleFileNotFound(lsn);
        LogEntryType type = entry.getLogType();
        for (int i = 0; i < expectTypes.length; ++i) {
            if (!(expectTypes[i].isLNType() ? type.isLNType() : type.equals(expectTypes[i]))) continue;
            return entry;
        }
        throw EnvironmentFailureException.unexpectedState("Expected: " + Arrays.toString(expectTypes) + " but got: " + type + " LSN=" + DbLsn.getNoFormatString(lsn));
    }

    private int getDeltaMemSize(long fileNum) {
        DbFileSummary summary = this.dbFileSummaries.get(fileNum);
        if (summary == null) {
            return 0;
        }
        float avgINSize = (float)summary.totalINSize / (float)summary.totalINCount;
        return (int)(avgINSize * 2.0f);
    }

    private boolean skipSlot(BIN bin, int index) {
        if (bin.isEntryPendingDeleted(index) || bin.isEntryKnownDeleted(index)) {
            return true;
        }
        return this.prevEndingKey != null && Key.compareKeys(this.prevEndingKey, bin.getKey(index), this.dbImpl.getKeyComparator()) >= 0;
    }

    private IN getFirstIN() {
        Tree tree = this.dbImpl.getTree();
        for (int i = 0; i < 25; ++i) {
            IN bin = this.prevEndingKey == null ? (BIN)tree.getFirstNode(CacheMode.UNCHANGED) : tree.search(this.prevEndingKey, Tree.SearchType.NORMAL, null, CacheMode.UNCHANGED, null);
            if (bin == null) {
                return null;
            }
            SearchResult result = tree.getParentINForChildIN(bin, true, CacheMode.UNCHANGED);
            IN parent = result.parent;
            if (!result.exactParentFound) {
                if (parent == null) continue;
                parent.releaseLatch();
                continue;
            }
            return parent;
        }
        throw EnvironmentFailureException.unexpectedState("Unable to find BIN for prevEndingKey: " + Arrays.toString(this.prevEndingKey));
    }

    private IN getNextIN(IN prevIn) {
        return this.dbImpl.getTree().getNextIN(prevIn, true, CacheMode.UNCHANGED);
    }

    static interface RecordProcessor {
        public void process(byte[] var1, byte[] var2);

        public boolean canProcessWithoutBlocking(int var1);
    }
}

