/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ReadCommittedLocker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;

public class LockerFactory {
    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean isInternalDb, boolean dbIsTransactional, boolean autoTxnIsReplicated) throws DatabaseException {
        return LockerFactory.getWritableLocker(env, userTxn, isInternalDb, dbIsTransactional, autoTxnIsReplicated, null);
    }

    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean isInternalDb, boolean dbIsTransactional, boolean autoTxnIsReplicated, TransactionConfig autoCommitConfig) throws DatabaseException {
        Transaction xaLocker;
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        boolean envIsTransactional = envImpl.isTransactional();
        if (userTxn == null && (xaLocker = env.getThreadTransaction()) != null) {
            return DbInternal.getLocker(xaLocker);
        }
        if (dbIsTransactional && userTxn == null) {
            if (autoCommitConfig == null) {
                autoCommitConfig = DbInternal.getDefaultTxnConfig(env);
            }
            return Txn.createAutoTxn(envImpl, autoCommitConfig, autoTxnIsReplicated ? ReplicationContext.MASTER : ReplicationContext.NO_REPLICATE);
        }
        if (userTxn == null) {
            return ThreadLocker.createThreadLocker(envImpl);
        }
        if (!isInternalDb && !envIsTransactional) {
            throw new IllegalArgumentException("A Transaction cannot be used because the environment was opened non-transactionally");
        }
        if (!dbIsTransactional) {
            throw new IllegalArgumentException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = DbInternal.getLocker(userTxn);
        if (locker.isReadCommittedIsolation()) {
            return ReadCommittedLocker.createReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }

    public static Locker getReadableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional, boolean readCommittedIsolation) throws DatabaseException {
        if (userTxn != null && !dbIsTransactional) {
            throw new IllegalArgumentException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = null;
        if (userTxn != null && (locker = DbInternal.getLocker(userTxn)).isReadCommittedIsolation()) {
            readCommittedIsolation = true;
        }
        return LockerFactory.getReadableLocker(env, locker, readCommittedIsolation);
    }

    public static Locker getReadableLocker(Environment env, Database dbHandle, Locker locker, boolean readCommittedIsolation) throws DatabaseException {
        DatabaseImpl dbImpl = DbInternal.getDatabaseImpl(dbHandle);
        if (!dbImpl.isTransactional() && locker != null && locker.isTransactional()) {
            throw new IllegalArgumentException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        if (locker != null && !locker.isTransactional()) {
            locker = null;
        }
        if (locker != null && locker.isReadCommittedIsolation()) {
            readCommittedIsolation = true;
        }
        return LockerFactory.getReadableLocker(env, locker, readCommittedIsolation);
    }

    public static Locker getInternalReadOperationLocker(EnvironmentImpl envImpl) {
        return BasicLocker.createBasicLocker(envImpl);
    }

    private static Locker getReadableLocker(Environment env, Locker locker, boolean readCommittedIsolation) throws DatabaseException {
        Transaction xaTxn;
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        if (locker == null && (xaTxn = env.getThreadTransaction()) != null) {
            return DbInternal.getLocker(xaTxn);
        }
        if (locker == null) {
            locker = ThreadLocker.createThreadLocker(envImpl);
        } else if (readCommittedIsolation) {
            locker = ReadCommittedLocker.createReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }
}

