/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.FramedTransactionalGraph;
import com.tinkerpop.frames.annotations.AdjacencyAnnotationHandler;
import com.tinkerpop.frames.annotations.DomainAnnotationHandler;
import com.tinkerpop.frames.annotations.InVertexAnnotationHandler;
import com.tinkerpop.frames.annotations.IncidenceAnnotationHandler;
import com.tinkerpop.frames.annotations.OutVertexAnnotationHandler;
import com.tinkerpop.frames.annotations.PropertyMethodHandler;
import com.tinkerpop.frames.annotations.RangeAnnotationHandler;
import com.tinkerpop.frames.modules.Module;

public class FramedGraphFactory {
    private Module[] modules;

    public FramedGraphFactory(Module ... modules) {
        this.modules = modules;
    }

    public <T extends Graph> FramedGraph<T> create(T baseGraph) {
        FramedGraphConfiguration config = this.getConfiguration(Graph.class, baseGraph);
        FramedGraph<T> framedGraph = new FramedGraph<T>(baseGraph, config);
        return framedGraph;
    }

    public <T extends TransactionalGraph> FramedTransactionalGraph<T> create(T baseGraph) {
        FramedGraphConfiguration config = this.getConfiguration(TransactionalGraph.class, baseGraph);
        FramedTransactionalGraph<T> framedGraph = new FramedTransactionalGraph<T>(baseGraph, config);
        return framedGraph;
    }

    protected <T extends Graph> FramedGraphConfiguration getConfiguration(Class<T> requiredType, T baseGraph) {
        Object configuredGraph = baseGraph;
        FramedGraphConfiguration config = this.getBaseConfig();
        for (Module module : this.modules) {
            if (requiredType.isInstance(configuredGraph = module.configure((Graph)configuredGraph, config))) continue;
            throw new UnsupportedOperationException("Module '" + module.getClass() + "' returned a '" + baseGraph.getClass().getName() + "' but factory requires '" + requiredType.getName() + "'");
        }
        config.setConfiguredGraph((Graph)configuredGraph);
        return config;
    }

    private FramedGraphConfiguration getBaseConfig() {
        FramedGraphConfiguration config = new FramedGraphConfiguration();
        config.addMethodHandler(new PropertyMethodHandler());
        config.addAnnotationHandler(new AdjacencyAnnotationHandler());
        config.addAnnotationHandler(new IncidenceAnnotationHandler());
        config.addAnnotationHandler(new DomainAnnotationHandler());
        config.addAnnotationHandler(new RangeAnnotationHandler());
        config.addAnnotationHandler(new InVertexAnnotationHandler());
        config.addAnnotationHandler(new OutVertexAnnotationHandler());
        return config;
    }
}

