/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.graph.MapInAdjacentProperties;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class MapInAdjacentPropertiesHandler
implements MethodHandler<MapInAdjacentProperties> {
    private static final Logger log = Logging.get(MapInAdjacentPropertiesHandler.class);

    public Class<MapInAdjacentProperties> getAnnotationType() {
        return MapInAdjacentProperties.class;
    }

    public Map<String, Serializable> processElement(Object frame, Method method, Object[] arguments, MapInAdjacentProperties annotation, FramedGraph<?> framedGraph, Element elm) {
        if (!(elm instanceof Vertex)) {
            throw new WindupException("@" + MapInAdjacentProperties.class.getSimpleName() + " is only supported on Vertex objects.");
        }
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.handleGetter((Vertex)elm, method, arguments, annotation, framedGraph);
        }
        if (methodName.startsWith("set")) {
            this.handleSetter((Vertex)elm, method, arguments, annotation, framedGraph);
            return null;
        }
        throw new WindupException("Only get* and set* method names are supported for @" + MapInAdjacentProperties.class.getSimpleName());
    }

    private Map<String, Serializable> handleGetter(Vertex vertex, Method method, Object[] args, MapInAdjacentProperties ann, FramedGraph<?> framedGraph) {
        if (args != null && args.length != 0) {
            throw new WindupException("Method must take no arguments: " + method.getName());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Iterable verts = vertex.getVertices(Direction.OUT, new String[]{ann.label()});
        Vertex mapVertex = null;
        Iterator it = verts.iterator();
        if (!it.hasNext()) {
            return map;
        }
        mapVertex = (Vertex)it.next();
        if (it.hasNext()) {
            log.warning("Found multiple vertices for a map, using only first one; for: " + method.getName());
        }
        Set keys = mapVertex.getPropertyKeys();
        for (String key : keys) {
            Object val = mapVertex.getProperty(key);
            if (!(val instanceof String)) {
                log.warning("@InProperties is meant for Map<String,Serializable>, but the value was: " + val.getClass());
            }
            map.put(key, (Serializable)((Object)("" + val)));
        }
        return map;
    }

    private void handleSetter(Vertex vertex, Method method, Object[] args, MapInAdjacentProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length != 1) {
            throw new WindupException("Method must take one argument: " + method.getName());
        }
        if (!(args[0] instanceof Map)) {
            throw new WindupException("Argument of " + method.getName() + " must be a Map, but is: " + args[0].getClass());
        }
        Map map = (Map)args[0];
        Iterable verts = vertex.getVertices(Direction.OUT, new String[]{ann.label()});
        Vertex mapVertex = null;
        Iterator it = verts.iterator();
        if (!it.hasNext()) {
            mapVertex = framedGraph.addVertex(null);
            vertex.addEdge(ann.label(), mapVertex);
        } else {
            mapVertex = (Vertex)it.next();
            if (it.hasNext()) {
                log.warning("Found multiple vertices for a map, using only first one; for: " + method.getName());
            }
        }
        Set keys = mapVertex.getPropertyKeys();
        Set mapKeys = map.keySet();
        for (String key : keys) {
            Object val = mapVertex.getProperty(key);
            if (!(val instanceof String)) {
                log.warning("@InProperties is meant for Map<String,Serializable>, but the value was: " + val.getClass());
            }
            if (map.containsKey(key)) {
                mapVertex.setProperty(key, map.get(key));
                mapKeys.remove(key);
                continue;
            }
            mapVertex.removeProperty(key);
        }
        for (String key : mapKeys) {
            mapVertex.setProperty(key, map.get(key));
        }
    }
}

