/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.impl.FurnaceImpl;
import org.jboss.forge.furnace.impl.addons.AddonImpl;
import org.jboss.forge.furnace.impl.addons.AddonLoader;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;
import org.jboss.forge.furnace.impl.addons.StartEnabledAddonCallable;
import org.jboss.forge.furnace.impl.addons.StopAddonCallable;
import org.jboss.forge.furnace.impl.event.AddonViewEventManager;
import org.jboss.forge.furnace.impl.graph.CompleteAddonGraph;
import org.jboss.forge.furnace.impl.graph.MasterGraph;
import org.jboss.forge.furnace.impl.graph.MasterGraphChangeHandler;
import org.jboss.forge.furnace.impl.graph.OptimizedAddonGraph;
import org.jboss.forge.furnace.impl.modules.AddonModuleLoader;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Callables;
import org.jboss.forge.furnace.util.Sets;

public class AddonLifecycleManager {
    private static final Logger logger = Logger.getLogger(AddonLifecycleManager.class.getName());
    private final LockManager lock;
    private final FurnaceImpl furnace;
    private final AddonLoader loader;
    private final AddonStateManager stateManager;
    private final Map<AddonView, Set<Addon>> addonViews = new ConcurrentHashMap<AddonView, Set<Addon>>();
    private final Map<AddonView, Long> views = new ConcurrentHashMap<AddonView, Long>();
    private final AtomicInteger starting = new AtomicInteger(-1);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final AddonModuleLoader moduleLoader;

    public AddonLifecycleManager(FurnaceImpl furnace) {
        Assert.notNull((Object)furnace, (String)"Furnace instance must not be null.");
        this.furnace = furnace;
        this.lock = furnace.getLockManager();
        this.stateManager = new AddonStateManager(this.lock);
        this.moduleLoader = new AddonModuleLoader(furnace, this, this.stateManager);
        this.stateManager.setModuleLoader(this.moduleLoader);
        this.loader = new AddonLoader(furnace, this, this.stateManager, this.moduleLoader);
    }

    public void dispose() {
        for (AddonView view : this.views.keySet()) {
            view.dispose();
        }
        this.views.clear();
        this.stateManager.dispose();
        this.loader.dispose();
        this.moduleLoader.dispose();
    }

    public long getVersion(AddonView view) {
        Long version = this.views.get(view);
        return version == null ? 0L : version;
    }

    public Addon getAddon(Set<AddonView> views, AddonId id) {
        Assert.notNull(views, (String)"Addon view set must not be null.");
        Assert.isTrue((!views.isEmpty() ? 1 : 0) != 0, (String)"Addon view set must not be empty.");
        Assert.notNull((Object)id, (String)"Addon ID must not be null.");
        return this.getAddon(views.iterator().next(), id);
    }

    public Set<Addon> getOrphanAddons(final AddonId id) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<Addon>>(){

            @Override
            public Set<Addon> call() throws Exception {
                HashSet<Addon> result = new HashSet<Addon>();
                for (Map.Entry entry : AddonLifecycleManager.this.addonViews.entrySet()) {
                    for (Addon addon : (Set)entry.getValue()) {
                        if (!addon.getId().equals((Object)id) || !AddonLifecycleManager.this.stateManager.getViewsOf(addon).isEmpty()) continue;
                        result.add(addon);
                    }
                }
                return result;
            }
        });
    }

    public Addon getAddon(final AddonView view, final AddonId id) {
        Assert.notNull((Object)view, (String)"AddonView must not be null.");
        Assert.notNull((Object)id, (String)"AddonId must not be null.");
        return (Addon)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Addon>(){

            @Override
            public Addon call() throws Exception {
                Addon result = null;
                for (Addon addon : AddonLifecycleManager.this.getAddons(view)) {
                    if (!id.equals((Object)addon.getId())) continue;
                    result = addon;
                    break;
                }
                if (result == null) {
                    result = AddonLifecycleManager.this.stateManager.getAddonForView(view, id);
                    if (result == null) {
                        result = new AddonImpl(AddonLifecycleManager.this.stateManager, id);
                    }
                    Set addons = AddonLifecycleManager.this._getAddonsForView(view);
                    addons.add(result);
                }
                return result;
            }
        });
    }

    public Set<Addon> getAddons(AddonView view) {
        return this.getAddons(view, AddonFilters.all());
    }

    public Set<Addon> getAddons(final AddonView view, final AddonFilter filter) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<Addon>>(){

            @Override
            public Set<Addon> call() throws Exception {
                HashSet<Addon> result = new HashSet<Addon>();
                for (Addon addon : AddonLifecycleManager.this._getAddonsForView(view)) {
                    if (!filter.accept((Object)addon)) continue;
                    result.add(addon);
                }
                return result;
            }
        });
    }

    private Set<Addon> _getAddonsForView(AddonView view) {
        Set addons = this.addonViews.get(view);
        if (addons == null) {
            addons = Sets.getConcurrentSet();
            this.addonViews.put(view, addons);
        }
        return addons;
    }

    public void forceUpdate() {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MasterGraph master = new MasterGraph();
                for (AddonView view : AddonLifecycleManager.this.views.keySet()) {
                    if (AddonLifecycleManager.this.starting.get() == -1) {
                        AddonLifecycleManager.this.starting.set(0);
                    }
                    OptimizedAddonGraph graph = new OptimizedAddonGraph(view, new CompleteAddonGraph(view.getRepositories()).getGraph());
                    master.merge(graph);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    String graphOutput = master.toString();
                    logger.log(Level.FINE, "\n ------------ VIEW [" + view.getName() + " - " + view.hashCode() + "]------------ " + (graphOutput.isEmpty() ? "EMPTY" : graphOutput) + " ------------ END [" + view.getName() + " - " + view.hashCode() + "]------------ ");
                }
                MasterGraph last = AddonLifecycleManager.this.stateManager.getCurrentGraph();
                AddonLifecycleManager.this.stateManager.setCurrentGraph(master);
                new MasterGraphChangeHandler(AddonLifecycleManager.this, last, master).hotSwapChanges();
                return null;
            }
        });
    }

    public void loadAddon(Addon addon) {
        try {
            this.loader.loadAddon(addon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopAddon(Addon addon) {
        Callables.call((Callable)new StopAddonCallable(this.stateManager, addon));
        this.incrementViewVersions(addon);
    }

    private void incrementViewVersions(Addon addon) {
        for (Map.Entry<AddonView, Long> entry : this.views.entrySet()) {
            if (!this.stateManager.getViewsOf(addon).contains(entry.getKey())) continue;
            entry.setValue(entry.getValue() + 1L);
        }
    }

    public void stopAll() {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Map.Entry entry : AddonLifecycleManager.this.addonViews.entrySet()) {
                    for (Addon addon : (Set)entry.getValue()) {
                        AddonLifecycleManager.this.stopAddon(addon);
                    }
                }
                List<Runnable> waiting = AddonLifecycleManager.this.executor.shutdownNow();
                if (waiting != null && !waiting.isEmpty()) {
                    logger.info("(" + waiting.size() + ") addons were aborted while loading due to forced shutdown.");
                }
                AddonLifecycleManager.this.starting.set(-1);
                return null;
            }
        });
    }

    public void finishedStarting(Addon addon) {
        this.starting.decrementAndGet();
        this.incrementViewVersions(addon);
    }

    public boolean isStartingAddons() {
        if (this.starting.get() == -1) {
            return false;
        }
        return this.starting.get() > 0;
    }

    public void startAddon(Addon addon) {
        Assert.notNull((Object)addon, (String)"Addon to start must not be null.");
        Callables.call((Callable)new StartEnabledAddonCallable(this.furnace, this, this.stateManager, this.executor, this.starting, addon));
    }

    public AddonView getRootView() {
        return this.furnace.getAddonRegistry(new AddonRepository[0]);
    }

    public void addView(AddonView view) {
        this.views.put(view, 0L);
    }

    public AddonRegistry findView(AddonRepository ... repositories) {
        AddonRegistry result = null;
        List<AddonRepository> furnaceRepositories = this.furnace.getRepositories();
        for (AddonView view : this.views.keySet()) {
            Set viewRepositories = view.getRepositories();
            if (repositories == null || repositories.length == 0) {
                if (viewRepositories.containsAll(furnaceRepositories) && furnaceRepositories.containsAll(viewRepositories)) {
                    result = (AddonRegistry)view;
                }
            } else if (viewRepositories.containsAll(Arrays.asList(repositories)) && Arrays.asList(repositories).containsAll(viewRepositories)) {
                result = (AddonRegistry)view;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public void removeView(AddonView view) {
        if (!this.views.keySet().contains(view)) {
            throw new IllegalArgumentException("The given view does not belong to this Furnace instance.");
        }
        this.views.remove(view);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (AddonView view : this.addonViews.keySet()) {
            builder.append("---").append(view.toString()).append("\n");
        }
        return builder.toString();
    }

    public String toGraph() {
        return this.stateManager.getCurrentGraph().toString();
    }

    public EventManager getEventManager(AddonView addonView) {
        return new AddonViewEventManager(addonView, this.lock);
    }
}

