/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.Durations;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.concurrent.TimeUnit;

public class StandardTimepoint
implements Timepoint {
    private final long sinceEpoch;
    private final TimestampProvider provider;

    private StandardTimepoint() {
        this.sinceEpoch = 0L;
        this.provider = null;
    }

    public StandardTimepoint(long sinceEpoch, TimestampProvider provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0);
        this.sinceEpoch = sinceEpoch;
        this.provider = provider;
    }

    @Override
    public long getTimestamp(TimeUnit returnUnit) {
        return returnUnit.convert(this.sinceEpoch, this.getNativeUnit());
    }

    @Override
    public StandardTimepoint add(Duration addend) {
        return new StandardTimepoint(this.sinceEpoch + addend.getLength(this.getNativeUnit()), this.provider);
    }

    @Override
    public StandardTimepoint sub(Duration subtrahend) {
        return new StandardTimepoint(this.sinceEpoch - subtrahend.getLength(this.getNativeUnit()), this.provider);
    }

    @Override
    public TimeUnit getNativeUnit() {
        return this.provider.getUnit();
    }

    @Override
    public long getNativeTimestamp() {
        return this.sinceEpoch;
    }

    @Override
    public TimestampProvider getProvider() {
        return this.provider;
    }

    @Override
    public Timepoint sleepPast() throws InterruptedException {
        return this.provider.sleepPast(this);
    }

    @Override
    public int compareTo(Timepoint other) {
        long theirs = other.getTimestamp(this.getNativeUnit());
        if (this.sinceEpoch < theirs) {
            return -1;
        }
        if (theirs < this.sinceEpoch) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return 527 + (int)(this.sinceEpoch ^ this.sinceEpoch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timepoint other = (Timepoint)obj;
        return other.getTimestamp(this.getNativeUnit()) == this.sinceEpoch;
    }

    public String toString() {
        return String.format("Timepoint[%d %s]", this.sinceEpoch, Durations.abbreviate(this.getNativeUnit()));
    }
}

