/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DirectionCondition<E extends TitanRelation>
extends Literal<E> {
    private final TitanVertex baseVertex;
    private final Direction direction;

    public DirectionCondition(TitanVertex vertex, Direction dir) {
        assert (vertex != null && dir != null);
        this.baseVertex = vertex;
        this.direction = dir;
    }

    @Override
    public boolean evaluate(E element) {
        if (this.direction == Direction.BOTH) {
            return true;
        }
        if (element instanceof CacheEdge) {
            return this.direction == ((CacheEdge)element).getVertexCentricDirection();
        }
        if (element instanceof TitanEdge) {
            return ((TitanEdge)element).getVertex(this.direction).equals(this.baseVertex);
        }
        if (element instanceof TitanProperty) {
            return this.direction == Direction.OUT;
        }
        return false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.direction).append((Object)this.baseVertex).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        DirectionCondition oth = (DirectionCondition)other;
        return this.direction == oth.direction && this.baseVertex.equals(oth.baseVertex);
    }

    @Override
    public String toString() {
        return "dir[" + this.getDirection() + "]";
    }
}

