/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.controller;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.impl.context.UIValidationContextImpl;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.util.Assert;

public abstract class AbstractCommandController
implements CommandController {
    protected final AddonRegistry addonRegistry;
    protected final UIRuntime runtime;
    protected final UIContext context;
    protected final UICommand initialCommand;
    private static final Logger log = Logger.getLogger(AbstractCommandController.class.getName());

    protected AbstractCommandController(AddonRegistry addonRegistry, UIRuntime runtime, UICommand initialCommand, UIContext context) {
        this.addonRegistry = addonRegistry;
        this.runtime = runtime;
        this.initialCommand = initialCommand;
        this.context = context;
    }

    protected void assertInitialized() {
        Assert.isTrue((boolean)this.isInitialized(), (String)"Controller must be initialized.");
    }

    protected void assertValid() {
        Assert.isTrue((boolean)this.isValid(), (String)"Controller is not in valid state.");
    }

    public List<UIMessage> validate(InputComponent<?, ?> input) {
        this.assertInitialized();
        Assert.notNull(input, (String)"InputComponent must not be null.");
        Assert.isTrue((boolean)this.getInputs().values().contains(input), (String)"InputComponent must belong to this command.");
        UIValidationContextImpl validationContext = new UIValidationContextImpl(this.context);
        input.validate((UIValidationContext)validationContext);
        return validationContext.getMessages();
    }

    public UIContext getContext() {
        return this.context;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CommandController) {
            Set newInputNames;
            Set originalInputNames;
            CommandController newController = (CommandController)obj;
            if (!this.getCommand().getClass().getName().equals(newController.getCommand().getClass().getName())) {
                result = false;
            } else if (this.isInitialized() && newController.isInitialized() && (originalInputNames = this.getInputs().keySet()).containsAll(newInputNames = newController.getInputs().keySet()) && newInputNames.containsAll(originalInputNames)) {
                result = true;
            }
        }
        return result;
    }

    protected void firePreCommandExecuted(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners, UICommand command) {
        for (CommandExecutionListener listener : listeners) {
            try {
                listener.preCommandExecuted(command, executionContext);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error while notifying listeners", t);
            }
        }
    }

    protected void firePostCommandFailure(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners, UICommand command, Throwable e) {
        for (CommandExecutionListener listener : listeners) {
            try {
                listener.postCommandFailure(command, executionContext, e);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error while notifying listeners", t);
            }
        }
    }

    protected void firePostCommandExecuted(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners, UICommand command, Result currentResult) {
        for (CommandExecutionListener listener : listeners) {
            try {
                listener.postCommandExecuted(command, executionContext, currentResult);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error while notifying listeners", t);
            }
        }
    }
}

