/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.inject.Inject;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.util.PathUtil;

public class WindupUpdateDistributionCommand
implements UICommand {
    @Inject
    Addon currentAddon;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Update Distribution").description("Update the whole windup installation").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Version installedVersion;
        if (!context.getPrompt().promptBoolean("Are you sure you want to continue? This command will delete current directories: addons, bin, lib, rules/migration-core")) {
            return Results.fail((String)"Updating distribution was aborted.");
        }
        List distributionVersions = this.dependencyResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)CoordinateBuilder.create().setGroupId("org.jboss.windup").setArtifactId("windup-distribution")));
        Coordinate latestDistributionCoordinate = (Coordinate)distributionVersions.get(distributionVersions.size() - 1);
        int i = 0;
        while ((latestDistributionCoordinate = (Coordinate)distributionVersions.get(distributionVersions.size() - ++i)).isSnapshot()) {
        }
        SingleVersion latestVersion = new SingleVersion(latestDistributionCoordinate.getVersion());
        if (latestVersion.compareTo((Object)(installedVersion = this.currentAddon.getId().getVersion())) <= 0) {
            return Results.fail((String)"Windup is already in the most updated version.");
        }
        Path windupRulesDir = PathUtil.getWindupRulesDir();
        Path addonsDir = PathUtil.getWindupAddonsDir();
        Path binDir = PathUtil.getWindupHome().resolve(PathUtil.BINARY_DIRECTORY_NAME);
        Path libDir = PathUtil.getWindupHome().resolve(PathUtil.LIBRARY_DIRECTORY_NAME);
        Path coreRulesPropertiesPath = windupRulesDir.resolve("migration-core");
        this.deleteWholeDirectory(coreRulesPropertiesPath);
        this.deleteWholeDirectory(addonsDir);
        this.deleteWholeDirectory(libDir);
        this.deleteWholeDirectory(binDir);
        Dependency dependency = this.dependencyResolver.resolveArtifact((DependencyQuery)DependencyQueryBuilder.create((Coordinate)CoordinateBuilder.create().setGroupId(latestDistributionCoordinate.getGroupId()).setArtifactId(latestDistributionCoordinate.getArtifactId()).setVersion(latestDistributionCoordinate.getVersion()).setClassifier("offline").setPackaging("zip")));
        FileResource artifact = dependency.getArtifact();
        ZipFile zipFile = new ZipFile(artifact.getFullyQualifiedName());
        File tempFolder = OperatingSystemUtils.createTempDir();
        String tempFolderPath = tempFolder.getAbsolutePath();
        zipFile.extractAll(tempFolderPath);
        FilenameFilter windupUnzipped = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.contains("windup-distribution");
            }
        };
        File[] windupDistrubution = new File(tempFolderPath).listFiles(windupUnzipped);
        String distributionExctractedPath = windupDistrubution[0].getAbsolutePath();
        FileUtils.copyDirectory((File)new File(distributionExctractedPath + "/" + "addons"), (File)addonsDir.toFile());
        FileUtils.copyDirectory((File)new File(distributionExctractedPath + "/" + PathUtil.BINARY_DIRECTORY_NAME), (File)binDir.toFile());
        FileUtils.copyDirectory((File)new File(distributionExctractedPath + "/" + PathUtil.LIBRARY_DIRECTORY_NAME), (File)libDir.toFile());
        File downloadedMigrationCore = new File(distributionExctractedPath + "/" + "rules" + "/" + "migration-core");
        if (downloadedMigrationCore.exists()) {
            FileUtils.copyDirectory((File)downloadedMigrationCore, (File)coreRulesPropertiesPath.toFile());
        } else {
            FileUtils.copyDirectory((File)new File(distributionExctractedPath + "/" + "rules"), (File)coreRulesPropertiesPath.toFile());
        }
        return Results.success((String)("Sucessfully updated to version " + latestDistributionCoordinate.getVersion() + ". Please restart windup."));
    }

    private void deleteWholeDirectory(Path directory) throws IOException {
        if (directory.toFile().exists()) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public void validate(UIValidationContext context) {
    }
}

