/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.inject.Inject;
import net.lingala.zip4j.core.ZipFile;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.windup.ui.RulesetUpdateChecker;
import org.jboss.windup.util.PathUtil;

public class WindupUpdateRulesetCommand
implements UICommand {
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Update Ruleset").description("Update the ruleset containing the migration rules").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Coordinate latestCoordinate;
        if (!RulesetUpdateChecker.rulesetNeedUpdate(this.dependencyResolver)) {
            return Results.fail((String)"The ruleset is already in the most updated version.");
        }
        List resolveVersions = this.dependencyResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)CoordinateBuilder.create().setGroupId("org.jboss.windup.rules").setArtifactId("windup-rulesets")));
        int i = 0;
        while ((latestCoordinate = (Coordinate)resolveVersions.get(resolveVersions.size() - ++i)).isSnapshot()) {
        }
        Path windupRulesDir = PathUtil.getWindupRulesDir();
        Path coreRulesPropertiesPath = windupRulesDir.resolve("migration-core");
        Files.walkFileTree(coreRulesPropertiesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        Dependency dependency = this.dependencyResolver.resolveArtifact((DependencyQuery)DependencyQueryBuilder.create((Coordinate)CoordinateBuilder.create().setGroupId(latestCoordinate.getGroupId()).setArtifactId(latestCoordinate.getArtifactId()).setVersion(latestCoordinate.getVersion())));
        FileResource artifact = dependency.getArtifact();
        ZipFile zipFile = new ZipFile(artifact.getFullyQualifiedName());
        String destinationFolder = coreRulesPropertiesPath.toAbsolutePath().toString();
        zipFile.extractAll(destinationFolder);
        return Results.success((String)("Sucessfully updated to version " + latestCoordinate.getVersion()));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public void validate(UIValidationContext context) {
    }
}

