/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class DecimalLiteralImpl
extends LiteralImpl {
    private static final long serialVersionUID = -3310213093222314380L;
    private final BigDecimal value;

    public DecimalLiteralImpl(BigDecimal value) {
        this(value, XMLSchema.DECIMAL);
    }

    public DecimalLiteralImpl(BigDecimal value, URI datatype) {
        super(value.toPlainString(), datatype);
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }
}

