/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfListUtil {
    private static final Logger log = LoggerFactory.getLogger(RdfListUtil.class);
    public static final boolean DEFAULT_CHECK_CYCLES = true;
    public static final boolean DEFAULT_CHECK_INCOMPLETE = true;
    public static final boolean DEFAULT_USE_ITERATIVE_ON_ERROR = true;
    private final boolean checkCycles;
    private final boolean checkIncomplete;
    private final boolean useIterativeOnError;

    public RdfListUtil() {
        this(true, true, true);
    }

    public RdfListUtil(boolean checkCycles, boolean checkIncomplete, boolean useIterativeOnError) {
        this.checkCycles = checkCycles;
        this.checkIncomplete = checkIncomplete;
        this.useIterativeOnError = useIterativeOnError;
    }

    public void addList(Resource head, List<Value> nextValues, Graph graphToAddTo, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ValueFactory vf = graphToAddTo.getValueFactory();
        Resource aCurr = head;
        int i = 0;
        for (Value nextValue : nextValues) {
            BNode aNext = vf.createBNode();
            graphToAddTo.add(aCurr, RDF.FIRST, nextValue, contexts);
            if (++i < nextValues.size()) {
                graphToAddTo.add(aCurr, RDF.REST, (Value)aNext, contexts);
            } else {
                graphToAddTo.add(aCurr, RDF.REST, (Value)RDF.NIL, contexts);
            }
            aCurr = aNext;
        }
    }

    public void addListAtNode(Resource subject, URI predicate, List<Value> nextValues, Graph graphToAddTo, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ValueFactory vf = graphToAddTo.getValueFactory();
        BNode aHead = vf.createBNode();
        if (nextValues.size() > 0) {
            graphToAddTo.add(subject, predicate, (Value)aHead, contexts);
        }
        this.addList((Resource)aHead, nextValues, graphToAddTo, contexts);
    }

    public List<Value> getList(Resource head, Graph graphToSearch, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        Collection<List<Value>> results = this.getLists(Collections.singleton(head), graphToSearch, contexts);
        if (results.size() > 1) {
            throw new RuntimeException("Found more than one list, possibly due to forking");
        }
        if (results.size() == 1) {
            return results.iterator().next();
        }
        return Collections.emptyList();
    }

    public List<Value> getListAtNode(Resource subject, URI predicate, Graph graphToSearch, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        Collection<List<Value>> allLists = this.getListsAtNode(subject, predicate, graphToSearch, contexts);
        if (allLists.size() > 1) {
            throw new RuntimeException("Found more than one list, possibly due to forking");
        }
        if (allLists.size() == 1) {
            return allLists.iterator().next();
        }
        return Collections.emptyList();
    }

    public Collection<List<Value>> getListsIterative(Set<Resource> heads, Graph graphToSearch, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ArrayList<List<Value>> results = new ArrayList<List<Value>>(heads.size());
        ArrayList<List<Resource>> completedPointerTrails = new ArrayList<List<Resource>>(heads.size());
        for (Resource nextHead : heads) {
            if (nextHead == null || nextHead.equals(RDF.NIL)) {
                throw new RuntimeException("List structure contains nulls or RDF.NIL in a head position");
            }
            this.followPointerTrails(nextHead, graphToSearch, completedPointerTrails, contexts);
            results.addAll(this.getValuesForPointerTrails(graphToSearch, completedPointerTrails, contexts));
            completedPointerTrails.clear();
        }
        return results;
    }

    public Collection<List<Value>> getLists(Set<Resource> heads, Graph graphToSearch, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        Collection<List<Value>> matches = new LinkedList<List<Value>>();
        try {
            for (Resource h : heads) {
                matches.addAll(this.getListsRecursive(h, graphToSearch, contexts));
            }
        }
        catch (RuntimeException rex) {
            if (this.getUseIterativeOnError() && rex.getMessage().contains("List was too long")) {
                matches.clear();
                matches = this.getListsIterative(heads, graphToSearch, contexts);
            }
            throw rex;
        }
        return matches;
    }

    public Collection<List<Value>> getListsRecursive(Resource head, Graph graph, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        LinkedList<List<Value>> matches = new LinkedList<List<Value>>();
        HashSet<Resource> prev = new HashSet<Resource>();
        Value[] buffer = new Value[1000];
        this.matchLists(head, graph, matches, prev, buffer, 0, contexts);
        return matches;
    }

    private void matchLists(Resource head, Graph graph, Collection<List<Value>> matches, Set<Resource> prev, Value[] buffer, int i, Resource ... contexts) {
        if (head.equals(RDF.NIL)) {
            ArrayList<Value> finalisedList = new ArrayList<Value>(i);
            for (int j = 0; j < i; ++j) {
                finalisedList.add(j, buffer[j]);
            }
            matches.add(finalisedList);
        } else {
            if (this.getCheckIncomplete() && !(head instanceof Resource)) {
                throw new RuntimeException("List structure was not complete");
            }
            if (!prev.contains(head)) {
                prev.add(head);
                Iterator first = graph.match(head, RDF.FIRST, null, contexts);
                if (this.getCheckIncomplete() && !first.hasNext()) {
                    throw new RuntimeException("List structure was not complete");
                }
                while (first.hasNext()) {
                    buffer[i] = ((Statement)first.next()).getObject();
                    Iterator rest = graph.match(head, RDF.REST, null, contexts);
                    if (this.getCheckIncomplete() && !rest.hasNext()) {
                        throw new RuntimeException("List structure was not complete");
                    }
                    while (rest.hasNext()) {
                        Value r = ((Statement)rest.next()).getObject();
                        if (r instanceof Resource) {
                            if (i + 1 >= buffer.length) {
                                throw new RuntimeException(String.format("List was too long, maximum is %d elements long", buffer.length));
                            }
                            this.matchLists((Resource)r, graph, matches, prev, buffer, i + 1, new Resource[0]);
                            continue;
                        }
                        if (!this.getCheckIncomplete()) continue;
                        throw new RuntimeException("List structure was not complete");
                    }
                }
                prev.remove(head);
            } else {
                if (prev.contains(head) && this.getCheckCycles()) {
                    throw new RuntimeException("List cannot contain cycles");
                }
                if (this.getCheckIncomplete()) {
                    throw new RuntimeException("List structure was not complete");
                }
            }
        }
    }

    private List<List<Value>> getValuesForPointerTrails(Graph graphToSearch, List<List<Resource>> completedPointerTrails, Resource ... contexts) {
        ArrayList<List<Value>> results = new ArrayList<List<Value>>(completedPointerTrails.size());
        for (List<Resource> nextPointerTrail : completedPointerTrails) {
            ArrayList<Value> nextResult = new ArrayList<Value>();
            for (int i = 0; i < nextPointerTrail.size(); ++i) {
                Resource nextPointer = nextPointerTrail.get(i);
                if (i == nextPointerTrail.size() - 1) {
                    if (nextPointer.equals(RDF.NIL)) continue;
                    throw new RuntimeException("Did not find RDF.NIL as the terminating element of a list");
                }
                if (nextPointer.equals(RDF.NIL)) {
                    throw new RuntimeException("Found RDF.NIL inside a list trail");
                }
                Value nextValue = null;
                Iterator valueMatch = graphToSearch.match(nextPointer, RDF.FIRST, null, contexts);
                if (valueMatch.hasNext()) {
                    Statement nextValueMatch = (Statement)valueMatch.next();
                    nextValue = nextValueMatch.getObject();
                    if (valueMatch.hasNext()) {
                        Statement errorValueMatch = (Statement)valueMatch.next();
                        log.error("Found multiple rdf:first items nextValueMatch=" + nextValueMatch + " errorValueMatch=" + errorValueMatch);
                        throw new RuntimeException("List structure cannot contain multiple values for rdf:first items for a given subject resource");
                    }
                }
                if (nextValue == null) {
                    throw new RuntimeException("List structure was not complete");
                }
                nextResult.add(nextValue);
            }
            if (nextResult.size() <= 0) continue;
            results.add(nextResult);
        }
        return results;
    }

    private void followPointerTrails(Resource nextHead, Graph graphToSearch, List<List<Resource>> completedPointerTrails, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ArrayList<Resource> firstPointerTrail = new ArrayList<Resource>();
        firstPointerTrail.add(nextHead);
        List<Object> currentPointerTrail = new ArrayList<Resource>(firstPointerTrail);
        ArrayList<List<Resource>> uncompletedPointerTrails = new ArrayList<List<Resource>>();
        Resource nextPointer = nextHead;
        boolean allDone = true;
        do {
            allDone = true;
            Iterator nextMatch = graphToSearch.match(nextPointer, RDF.REST, null, contexts);
            if (!nextMatch.hasNext()) {
                throw new RuntimeException("List structure was not complete");
            }
            allDone = this.resolveNextMatch(completedPointerTrails, currentPointerTrail, uncompletedPointerTrails, allDone, nextMatch);
            if (nextMatch.hasNext()) {
                while (nextMatch.hasNext()) {
                    if (this.resolveNextMatch(completedPointerTrails, currentPointerTrail, uncompletedPointerTrails, allDone, nextMatch)) continue;
                    allDone = false;
                }
            }
            if (uncompletedPointerTrails.isEmpty()) {
                currentPointerTrail = null;
                nextPointer = null;
                allDone = true;
                continue;
            }
            allDone = false;
            currentPointerTrail = (List)uncompletedPointerTrails.remove(uncompletedPointerTrails.size() - 1);
            nextPointer = (Resource)currentPointerTrail.get(currentPointerTrail.size() - 1);
        } while (!allDone);
    }

    private boolean resolveNextMatch(List<List<Resource>> completedPointerTrails, List<Resource> currentPointerTrail, List<List<Resource>> uncompletedPointerTrails, boolean allDone, Iterator<Statement> nextMatch) {
        Statement nextMatchStatement = nextMatch.next();
        Value nextValue = nextMatchStatement.getObject();
        if (nextValue instanceof Resource) {
            Resource nextResource = (Resource)nextValue;
            if (this.getCheckCycles() && currentPointerTrail.contains(nextResource)) {
                throw new RuntimeException("List cannot contain cycles");
            }
            ArrayList<Resource> nextTrail = new ArrayList<Resource>(currentPointerTrail);
            nextTrail.add(nextResource);
            if (nextResource.equals(RDF.NIL)) {
                completedPointerTrails.add(nextTrail);
            } else {
                allDone = false;
                uncompletedPointerTrails.add(nextTrail);
            }
        } else {
            throw new RuntimeException("List structure not valid");
        }
        return allDone;
    }

    public Collection<List<Value>> getListsAtNode(Resource subject, URI predicate, Graph graphToSearch, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        Iterator headStatementMatches = graphToSearch.match(subject, predicate, null, contexts);
        HashSet<Resource> heads = new HashSet<Resource>();
        while (headStatementMatches.hasNext()) {
            Statement nextHeadStatement = (Statement)headStatementMatches.next();
            if (!(nextHeadStatement.getObject() instanceof Resource)) continue;
            heads.add((Resource)nextHeadStatement.getObject());
        }
        Collection<List<Value>> results = this.getLists(heads, graphToSearch, contexts);
        return results;
    }

    public boolean getCheckCycles() {
        return this.checkCycles;
    }

    public boolean getCheckIncomplete() {
        return this.checkIncomplete;
    }

    public boolean getUseIterativeOnError() {
        return this.useIterativeOnError;
    }
}

