/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.dependencies;

import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.resource.AbstractFileResource;
import org.jboss.forge.addon.resource.DefaultFileOperations;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.addon.resource.transaction.ResourceTransaction;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionListener;
import org.jboss.forge.furnace.spi.ListenerRegistration;

@Vetoed
class FileResourceFactory
implements ResourceFactory {
    FileResourceFactory() {
    }

    public <E, T extends Resource<E>> T create(Class<T> type, E underlyingResource) {
        return (T)this.create(underlyingResource);
    }

    public <E> Resource<E> create(E underlyingResource) {
        if (underlyingResource instanceof File) {
            return this.createFileResource((File)underlyingResource);
        }
        return null;
    }

    private <E> Resource<E> createFileResource(File resource) {
        return new AbstractFileResource(this, resource){

            public Resource createFrom(File file) {
                return FileResourceFactory.this.createFileResource(file);
            }

            protected List<File> doListResources() {
                return Collections.emptyList();
            }
        };
    }

    public ResourceMonitor monitor(Resource<?> resource) {
        throw new UnsupportedOperationException();
    }

    public ResourceMonitor monitor(Resource<?> resource, ResourceFilter resourceFilter) {
        throw new UnsupportedOperationException();
    }

    public ResourceTransaction getTransaction() {
        throw new UnsupportedOperationException();
    }

    public FileOperations getFileOperations() {
        return DefaultFileOperations.INSTANCE;
    }

    public ListenerRegistration<ResourceTransactionListener> addTransactionListener(ResourceTransactionListener listener) {
        throw new UnsupportedOperationException();
    }
}

